/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.editor;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.Iterator;

public class EventTextHover
extends StoryTextHover {
    public EventTextHover() {
        super(EventRep.getInstance());
    }

    public String getHoverInfo(IStoryModel model, int hoverOffset, IHasPosition selection) {
        if (!model.supports(EventRep.getInstance())) {
            return null;
        }
        IDescSet eventDescs = model.getData().getDescriptions(EventRep.getInstance()).closedSet((IHasPosition)new SimplePosition(hoverOffset, 0));
        if (eventDescs.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Events:\n");
        Iterator i = eventDescs.iterator();
        while (i.hasNext()) {
            IDesc eventDesc = (IDesc)i.next();
            IEvent event = (IEvent)eventDesc.getData();
            sb.append(event.getEventTokens().getDisplayText());
            sb.append(" - ");
            sb.append(event.getEventClass().getName());
            sb.append(" (");
            sb.append(Long.toString(eventDesc.getID()));
            sb.append(')');
            if (!i.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

