/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.move.IMove;
import edu.mit.semantics.core.rep.move.MoveRep;
import edu.mit.semantics.core.rep.move.model.IMoveModel;
import edu.mit.semantics.core.rep.move.model.MoveModel;
import edu.mit.semantics.ui.controllers.IMoveController;
import edu.mit.semantics.ui.label.FunctionLabelProvider;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.AbstractSelectionDialogCaptureStrategy;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveController
implements IMoveController {
    private final IStoryEditor editor;
    private final IMoveModel moveModel;
    private final IDescController<IDescModel> functionController;

    public MoveController(String annoID, IStoryEditor editor) {
        this.editor = editor;
        this.moveModel = new MoveModel();
        DescModel funcModel = new DescModel((IStoryModel)editor.getStoryModel(), new IRep[]{FunctionRep.getInstance()});
        FunctionSelectionDialogCaptureStrategy strategy = new FunctionSelectionDialogCaptureStrategy(editor, (IDescModel)funcModel);
        this.functionController = new DescController((IDescModel)funcModel, annoID, editor, (ICaptureStrategy)strategy);
    }

    @Override
    public IMoveModel getModel() {
        return this.moveModel;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public IDescController<IDescModel> getFunctionController() {
        return this.functionController;
    }

    @Override
    public void setNumber(int number) {
        this.moveModel.setNumber(number);
    }

    @Override
    public void addFunction() {
        IDescModel functionModel = this.functionController.getDescModel();
        this.moveModel.getFunctions().add(functionModel.getDesc());
        this.functionController.clear();
    }

    @Override
    public void deleteFunction(IDesc func) {
        this.moveModel.getFunctions().remove(func);
    }

    @Override
    public void edit(IDesc desc) {
        this.getModel().load(desc);
    }

    @Override
    public void commit() {
        IMoveModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        IMove data = model.create();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)MoveRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    @Override
    public void clear() {
        this.getModel().clear();
        this.getFunctionController().clear();
    }

    public void dispose() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionSelectionDialogCaptureStrategy
    extends AbstractSelectionDialogCaptureStrategy {
        private final IDescModel model;
        private ILabelProvider lp;

        public FunctionSelectionDialogCaptureStrategy(IStoryEditor editor, IDescModel model) {
            super(editor);
            if (model == null) {
                throw new NullPointerException();
            }
            this.model = model;
        }

        protected ILabelProvider getLabelProvider() {
            if (this.lp == null) {
                this.lp = new FunctionLabelProvider(this.getStoryEditor());
            }
            return this.lp;
        }

        protected Set<IRep> getReps() {
            return this.model.getReps();
        }
    }
}

