/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.jpropbank.frames.IRole;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.ContextRole;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.context.model.ContextRelArgModel;
import edu.mit.semantics.core.rep.context.model.IContextRelArgModel;
import edu.mit.semantics.ui.controllers.IContextArgController;
import edu.mit.semantics.ui.dialogs.RolesetSelectionDialog;
import edu.mit.semantics.ui.label.ContextRelationLabelProvider;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.AbstractSelectionDialogCaptureStrategy;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.ui.dialogs.WordSelectionDialog;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextArgController
extends DescController<IContextRelArgModel>
implements IContextArgController {
    public ContextArgController(String annoID, IStoryEditor editor) {
        this((IContextRelArgModel)new ContextRelArgModel((IStoryModel)editor.getStoryModel()), annoID, editor);
    }

    public ContextArgController(IContextRelArgModel model, String annoID, IStoryEditor editor) {
        super((IDescModel)model, annoID, editor, (ICaptureStrategy)new ContextRelArgCaptureStrategy(editor, (IDescModel)model));
    }

    @Override
    public void chooseRole() {
        IContextRole.RoleType type = this.chooseType();
        if (type == null) {
            return;
        }
        switch (type) {
            case UNKNOWN: {
                this.setRole(IContextRole.UNKNOWN);
                return;
            }
            case NONE: {
                this.setRole(IContextRole.NONE);
                return;
            }
            case WORDNET: {
                ISynset synset = this.chooseWordnetRole();
                if (synset != null) {
                    this.setRole((IContextRole)new ContextRole(synset));
                }
                return;
            }
            case PROPBANK: {
                IRole pbRole = this.choosePropbankRole();
                if (pbRole != null) {
                    this.setRole((IContextRole)new ContextRole(pbRole));
                }
                return;
            }
        }
        throw new IllegalStateException("Should never get here");
    }

    protected IContextRole.RoleType chooseType() {
        String dialogTitle = "Choose Role Type";
        String dialogMessage = "Choose the type of role you would like to assign";
        IContextRole.RoleType[] types = IContextRole.RoleType.values();
        ArrayList<String> labels = new ArrayList<String>(types.length + 1);
        IContextRole.RoleType[] roleTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IContextRole.RoleType type = roleTypeArray[n2];
            labels.add("&" + type.getName());
            ++n2;
        }
        labels.add("&Cancel");
        String[] ls = labels.toArray(new String[labels.size()]);
        MessageDialog dialog = new MessageDialog(this.editor.getSite().getShell(), dialogTitle, null, dialogMessage, 3, ls, 5);
        dialog.setBlockOnOpen(true);
        dialog.open();
        int code = dialog.getReturnCode();
        if (code >= 0 && code < types.length) {
            return types[code];
        }
        return null;
    }

    protected ISynset chooseWordnetRole() {
        IWord word;
        IDictionary dict = ContextRelationRep.getDictionary((IStoryData)this.editor.getStoryModel().getData());
        IContextRole role = ((IContextRelArgModel)this.getDescModel()).getRole();
        String stem = "";
        if (role.getType() == IContextRole.RoleType.WORDNET) {
            stem = ((IWord)role.getWordnetRole().getWords().get(0)).getLemma();
        }
        if ((word = WordSelectionDialog.open((Shell)this.editor.getSite().getShell(), (IDictionary)dict, (String)stem, (boolean)true, (POS[])new POS[]{POS.NOUN, POS.ADJECTIVE})) != null) {
            return word.getSynset();
        }
        return null;
    }

    protected IRole choosePropbankRole() {
        return RolesetSelectionDialog.selectRole(this.getStoryEditor().getSite().getShell(), null);
    }

    @Override
    public void setHeadRole(boolean selection) {
        int group = selection ? 1 : 0;
        ((IContextRelArgModel)this.getDescModel()).setExclusionGroup(group);
    }

    @Override
    public void setContituentRole(boolean selection) {
        int depth = selection ? 1 : 0;
        ((IContextRelArgModel)this.getDescModel()).setDepth(depth);
    }

    @Override
    public void setRole(IContextRole role) {
        ((IContextRelArgModel)this.getDescModel()).setRole(role);
    }

    @Override
    public void edit(IContextArg arg) {
        ((IContextRelArgModel)this.getDescModel()).load(arg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextRelArgCaptureStrategy
    extends AbstractSelectionDialogCaptureStrategy {
        private final IDescModel model;
        private ILabelProvider lp;

        public ContextRelArgCaptureStrategy(IStoryEditor editor, IDescModel model) {
            super(editor);
            if (model == null) {
                throw new NullPointerException();
            }
            this.model = model;
        }

        protected ILabelProvider getLabelProvider() {
            if (this.lp == null) {
                this.lp = new ContextRelationLabelProvider(this.getStoryEditor());
            }
            return this.lp;
        }

        protected Set<IRep> getReps() {
            return this.model.getReps();
        }
    }
}

