/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.content;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.LinkedList;

public class FunctionContentProvider
extends StoryEditorContentProvider {
    public FunctionContentProvider(IStoryEditor input) {
        super(FunctionRep.getInstance(), input, "(no functions)");
    }

    public boolean hasChildren(Object element) {
        if (super.hasChildren(element)) {
            return true;
        }
        Object data = element;
        if (data instanceof IDesc) {
            IDesc desc = (IDesc)data;
            data = desc.getData();
        }
        if (data instanceof IFunction) {
            IFunction func = (IFunction)data;
            return !func.getInstances().isEmpty();
        }
        if (FunctionContentProvider.isElement((Object)data, IFunctionInstance.class)) {
            StoryEditorContentProvider.Element e = (StoryEditorContentProvider.Element)data;
            IFunctionInstance instance = (IFunctionInstance)e.getElement();
            return instance.getSegments().size() > 1;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parent) {
        Object[] defaultChildren = super.getChildren(parent);
        Object data = parent;
        if (data instanceof IDesc) {
            IDesc desc = (IDesc)data;
            data = desc.getData();
        }
        if (data instanceof IFunction) {
            IFunction func = (IFunction)data;
            LinkedList<Object> children = new LinkedList<Object>();
            for (IFunctionInstance instance : func.getInstances()) {
                children.add(FunctionContentProvider.makeChild((Object)parent, (Object)instance));
            }
            if (defaultChildren != null) {
                Object[] objectArray = defaultChildren;
                int n = defaultChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    children.add(child);
                    ++n2;
                }
            }
            return children.toArray();
        }
        if (FunctionContentProvider.isElement((Object)data, IFunctionInstance.class)) {
            StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)data;
            IFunctionInstance instance = (IFunctionInstance)element.getElement();
            if (instance.getSegments().size() == 1) {
                return emptyArray;
            }
            return instance.getSegments().toArray();
        }
        return defaultChildren;
    }
}

