/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.jpropbank.Feature;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.Label;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemArg;
import edu.mit.semantics.core.rep.semrole.SemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeSemArgActionGroup
extends ActionGroup {
    private List<IMenuManager> menus;

    public ChangeSemArgActionGroup(IStoryEditor editor) {
        this.createActions(editor);
    }

    public IRep getRep() {
        return SemRoleRep.getInstance();
    }

    protected void createActions(IStoryEditor editor) {
        Label[] labels = Label.values();
        Feature[] features = Feature.values();
        ArrayList<MenuManager> hidden = new ArrayList<MenuManager>(labels.length);
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            ArrayList<IAction> actions = new ArrayList<IAction>(features.length + 1);
            actions.add((IAction)new ChangeSemArgRoleAction(label, null, editor));
            Feature[] featureArray = features;
            int n3 = features.length;
            int n4 = 0;
            while (n4 < n3) {
                Feature feature = featureArray[n4];
                actions.add((IAction)new ChangeSemArgRoleAction(label, feature, editor));
                ++n4;
            }
            MenuManager labelMenu = new MenuManager(this.createLabelMenuText(label.name()));
            labelMenu.setRemoveAllWhenShown(true);
            labelMenu.addMenuListener((IMenuListener)new LabelMenuListener(actions));
            hidden.add(labelMenu);
            ++n2;
        }
        this.menus = Collections.unmodifiableList(hidden);
    }

    protected String createLabelMenuText(String text) {
        StringBuilder sb = new StringBuilder(text.length() + 1);
        sb.append(text);
        sb.insert(text.length() - 1, '&');
        return sb.toString();
    }

    protected String createFeatureActionText(Feature feature) {
        if (feature == null) {
            return "&None";
        }
        StringBuilder sb = new StringBuilder(feature.getDescription().length() + 1);
        sb.append('&');
        sb.append(feature.getDescription());
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), StoryEditorContentProvider.Element.class);
        Object obj = element;
        if (obj instanceof StoryEditorContentProvider.Element) {
            StoryEditorContentProvider.Element child = obj;
            obj = child.getElement();
        }
        if (obj instanceof ISemArg) {
            for (IMenuManager labelMenu : this.menus) {
                menu.appendToGroup("additions", (IContributionItem)labelMenu);
            }
        }
    }

    protected IDesc getTargetDesc() {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        if (element instanceof StoryEditorContentProvider.Element) {
            StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
            element = child.getParent();
        }
        if (element instanceof IDesc) {
            IDesc d = (IDesc)element;
            if (this.getRep().isType((IHasRep)d)) {
                return d;
            }
        }
        return null;
    }

    protected ISemArg getTargetSemArg() {
        StoryEditorContentProvider.Element element = (StoryEditorContentProvider.Element)SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), StoryEditorContentProvider.Element.class);
        if (element.getElement() instanceof ISemArg) {
            return (ISemArg)element.getElement();
        }
        return null;
    }

    protected class ChangeSemArgRoleAction
    extends Action {
        private String label;
        private String feature;
        private IStoryEditor editor;

        public ChangeSemArgRoleAction(Label label, Feature feature, IStoryEditor editor) {
            super(ChangeSemArgActionGroup.this.createFeatureActionText(feature), 2);
            if (label == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            this.label = label.name();
            this.feature = feature == null ? "" : feature.name();
            this.editor = editor;
        }

        public boolean isChecked() {
            return false;
        }

        public void run() {
            IDesc oldDesc = ChangeSemArgActionGroup.this.getTargetDesc();
            ISemRole oldSemRole = (ISemRole)oldDesc.getData();
            ISemArg selArg = ChangeSemArgActionGroup.this.getTargetSemArg();
            ArrayList<Object> newArgs = new ArrayList<Object>(oldSemRole.getArguments().size());
            for (ISemArg oldArg : oldSemRole.getArguments()) {
                if (oldArg == selArg) {
                    newArgs.add(new SemArg(oldSemRole.getRoleset(), this.label, this.feature, oldArg.getLocation()));
                    continue;
                }
                newArgs.add(oldArg);
            }
            SemRole newSemRole = new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), (IPredicateFeatures)oldSemRole, newArgs);
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newSemRole.calculatePosition(), (IData)newSemRole, (Iterable)oldDesc.getMetaData());
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LabelMenuListener
    implements IMenuListener {
        private final List<IAction> actions;

        public LabelMenuListener(List<IAction> actions) {
            if (actions == null) {
                throw new NullPointerException();
            }
            this.actions = actions;
        }

        public void menuAboutToShow(IMenuManager manager) {
            for (IAction action : this.actions) {
                manager.add(action);
            }
        }
    }
}

