/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.widgets;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.ButtonAction;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentCaptureWidget<C extends ISegmentController>
extends AnnotationWidget<C> {
    protected Text leftText;
    protected Text rightText;
    protected Spinner leftSpinner;
    protected Spinner rightSpinner;
    protected int leftValue;
    protected int rightValue;
    protected Button captureButton;
    protected Button clearButton;
    protected ButtonAction captureAction;
    protected ButtonAction clearAction;

    public SegmentCaptureWidget(Composite parent, int style, C controller) {
        super(parent, style, controller);
        controller.getModel().addChangeListener((ChangeListener)((Object)this));
    }

    public IAction getCaptureAction() {
        return this.captureAction;
    }

    public IAction getClearAction() {
        return this.clearAction;
    }

    protected void createControl(Composite parent) {
        GridData gd;
        GridLayout layout = new GridLayout(9, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        boolean isFull = (this.getStyle() & 0x10000) != 0;
        Composite leadingParent = new Composite(parent, 0);
        ColorManager.inheritColors((Control)leadingParent);
        leadingParent.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.createLeadingControls(leadingParent);
        if (!isFull) {
            this.leftText = new Text(parent, 2048);
            this.leftText.setBackground(parent.getBackground());
            this.leftText.setForeground(parent.getForeground());
            this.leftText.setEditable(false);
            gd = new GridData(4, 0x1000000, true, false);
            gd.minimumWidth = 30;
            this.leftText.setLayoutData((Object)gd);
        }
        this.leftSpinner = new Spinner(parent, 2056);
        this.leftSpinner.setBackground(parent.getBackground());
        this.leftSpinner.setForeground(parent.getForeground());
        this.leftSpinner.setMinimum(-1);
        this.leftSpinner.setMaximum(Integer.MAX_VALUE);
        this.leftSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SegmentCaptureWidget.this.leftSpinner.getSelection() > SegmentCaptureWidget.this.leftValue) {
                    ((ISegmentController)SegmentCaptureWidget.this.controller).nextLeft();
                } else if (SegmentCaptureWidget.this.leftSpinner.getSelection() < SegmentCaptureWidget.this.leftValue) {
                    ((ISegmentController)SegmentCaptureWidget.this.controller).previousLeft();
                }
            }
        });
        this.rightText = new Text(parent, 2048);
        this.rightText.setBackground(parent.getBackground());
        this.rightText.setForeground(parent.getForeground());
        this.rightText.setEditable(false);
        gd = new GridData(4, 0x1000000, true, false, isFull ? 2 : 1, 1);
        gd.minimumWidth = 30;
        this.rightText.setLayoutData((Object)gd);
        this.rightSpinner = new Spinner(parent, 2056);
        this.rightSpinner.setBackground(parent.getBackground());
        this.rightSpinner.setForeground(parent.getForeground());
        this.rightSpinner.setMinimum(-1);
        this.rightSpinner.setMaximum(Integer.MAX_VALUE);
        this.rightSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SegmentCaptureWidget.this.rightSpinner.getSelection() > SegmentCaptureWidget.this.rightValue) {
                    ((ISegmentController)SegmentCaptureWidget.this.controller).nextRight();
                } else if (SegmentCaptureWidget.this.rightSpinner.getSelection() < SegmentCaptureWidget.this.rightValue) {
                    ((ISegmentController)SegmentCaptureWidget.this.controller).previousRight();
                }
            }
        });
        this.captureButton = new Button(parent, 0);
        this.captureButton.setText("Capture");
        this.captureButton.setToolTipText("Capture from Editor");
        this.captureAction = new ButtonAction(this.captureButton){

            public void run() {
                ((ISegmentController)SegmentCaptureWidget.this.controller).capture();
            }
        };
        Composite trailingParent = new Composite(parent, 0);
        ColorManager.inheritColors((Control)trailingParent);
        trailingParent.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.createTrailingControls(trailingParent);
        this.clearButton = new Button(parent, 0);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear Field");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                ((ISegmentController)SegmentCaptureWidget.this.controller).clear();
            }
        };
        this.createAnnotateButton(parent);
    }

    protected void createLeadingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        parent.setLayout((Layout)new GridLayout());
    }

    protected void createTrailingControls(Composite parent) {
        GridData gd = (GridData)parent.getLayoutData();
        gd.widthHint = 0;
        parent.setLayout((Layout)new GridLayout());
    }

    protected void updateFromModel() {
        boolean clearEnabled;
        ISegmentModel segmentModel = ((ISegmentController)this.controller).getModel();
        IDescSet descs = segmentModel.getSegment();
        boolean isEmpty = descs.isEmpty();
        boolean isFull = this.leftText == null;
        int leftSpinnerSel = isEmpty ? 0 : descs.getOffset();
        int rightSpinnerSel = isEmpty ? 0 : descs.getRightOffset();
        String leftDisplayText = isFull ? null : segmentModel.getLeftText();
        String rightDisplayText = isFull ? segmentModel.getText() : segmentModel.getRightText();
        boolean bl = clearEnabled = !segmentModel.isCleared();
        if (this.leftSpinner.getSelection() != leftSpinnerSel) {
            this.leftSpinner.setSelection(leftSpinnerSel);
        }
        if (this.leftValue != leftSpinnerSel) {
            this.leftValue = leftSpinnerSel;
        }
        if (!isFull && !this.leftText.getText().equals(leftDisplayText)) {
            this.leftText.setText(leftDisplayText);
        }
        if (this.rightSpinner.getSelection() != rightSpinnerSel) {
            this.rightSpinner.setSelection(rightSpinnerSel);
        }
        if (this.rightValue != rightSpinnerSel) {
            this.rightValue = rightSpinnerSel;
        }
        if (!this.rightText.getText().equals(rightDisplayText)) {
            this.rightText.setText(rightDisplayText);
        }
        if (this.clearAction.isEnabled() != clearEnabled) {
            this.clearAction.setEnabled(clearEnabled);
        }
    }
}

