/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.widgets;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.IChangeNotifier;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollocationCaptureWidget
extends Composite
implements IChangeNotifier {
    protected boolean sentDisplaySync = false;
    protected boolean textDisplaySync = false;
    protected StyledText sentDisplay;
    protected Text textDisplay;
    protected Button addButton;
    protected Button subtractButton;
    protected Button clearButton;
    protected Button annotateButton;
    protected String tokenText;
    protected List<IToken> tokens;
    protected List<IToken> seeds;
    protected IHasPositionSet<IHasPosition> ranges = new HasPositionSet();
    protected Map<IHasPosition, IToken> tokenMap = new HashMap<IHasPosition, IToken>();
    protected Set<IToken> choices = CollectionUtils.newSetFromMap(new IdentityHashMap());
    private final ChangeNotifier notifier = new ChangeNotifier();

    public CollocationCaptureWidget(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    protected void createControl() {
        this.setLayout((Layout)new GridLayout());
        this.createSentenceView(this);
        Composite group = new Composite((Composite)this, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(4, false);
        group.setLayout((Layout)layout);
        this.createText(group);
        this.createAddButton(group);
        this.createSubtractButton(group);
        this.createClearButton(group);
    }

    protected void createSentenceView(Composite parent) {
        this.sentDisplay = new StyledText(parent, 2112);
        GridData gd = new GridData(4, 4, true, true);
        this.sentDisplay.setLayoutData((Object)gd);
        GC gc = new GC((Drawable)this.getDisplay());
        gc.setFont(this.sentDisplay.getFont());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        gd.heightHint = fm.getHeight() * 3;
        gd.widthHint = fm.getAverageCharWidth() * 100;
        this.sentDisplay.setEditable(false);
        JFaceColors.setColors((Control)this.sentDisplay, (Color)parent.getForeground(), (Color)this.getDisplay().getSystemColor(25));
    }

    protected void createText(Composite parent) {
        this.textDisplay = new Text(parent, 2048);
        this.textDisplay.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textDisplay.setEditable(false);
        JFaceColors.setColors((Control)this.textDisplay, (Color)parent.getForeground(), (Color)this.getDisplay().getSystemColor(25));
    }

    protected void createAddButton(Composite parent) {
        this.addButton = new Button(parent, 0);
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Add selected Region");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CollocationCaptureWidget.this.doAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createSubtractButton(Composite parent) {
        this.subtractButton = new Button(parent, 0);
        this.subtractButton.setText("Subtract");
        this.subtractButton.setToolTipText("Subtract selected Region");
        this.subtractButton.setEnabled(false);
        this.subtractButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CollocationCaptureWidget.this.doSubtract();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createClearButton(Composite parent) {
        this.clearButton = new Button(parent, 0);
        this.clearButton.setEnabled(false);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear Field");
        this.clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CollocationCaptureWidget.this.doClear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void setInput(List<IToken> newTokens, List<IToken> seeds) {
        this.tokens = newTokens;
        this.seeds = seeds;
        this.makePositionMap();
        this.choices.clear();
        if (seeds != null) {
            this.choices.addAll(seeds);
        }
        this.sentDisplaySync = true;
        this.textDisplaySync = true;
        this.updateControls();
    }

    public List<IToken> getResult() {
        if (this.choices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IToken> result = new ArrayList<IToken>(this.choices.size());
        for (IToken token : this.tokens) {
            if (!this.choices.contains(token)) continue;
            result.add(token);
        }
        return result;
    }

    protected void makePositionMap() {
        this.tokenMap.clear();
        this.ranges.clear();
        if (this.tokens == null) {
            this.tokenText = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<IToken> i = this.tokens.iterator();
        while (i.hasNext()) {
            IToken token = i.next();
            int start = sb.length();
            sb.append(token.getSurface());
            int end = sb.length();
            SimplePosition p = new SimplePosition(start, end - start);
            this.ranges.add((Object)p);
            this.tokenMap.put((IHasPosition)p, token);
            if (!i.hasNext() || !token.isFollowedByBreak()) continue;
            sb.append(" ");
        }
        this.tokenText = sb.toString();
    }

    public void doAdd() {
        Point pt = this.sentDisplay.getSelection();
        SimplePosition p = new SimplePosition(pt.x, pt.y - pt.x);
        for (IHasPosition r : this.ranges.openSet((IHasPosition)p)) {
            IToken token = this.tokenMap.get(r);
            if (token == null) continue;
            this.choices.add(token);
        }
        this.textDisplaySync = true;
        this.updateControls();
        this.notifyChangeListeners((Object)this);
    }

    public void doSubtract() {
        Point pt = this.sentDisplay.getSelection();
        SimplePosition p = new SimplePosition(pt.x, pt.y - pt.x);
        for (IHasPosition r : this.ranges.openSet((IHasPosition)p)) {
            IToken token = this.tokenMap.get(r);
            if (this.seeds != null && this.seeds.contains(token) || token == null) continue;
            this.choices.remove(token);
        }
        this.textDisplaySync = true;
        this.updateControls();
        this.notifyChangeListeners((Object)this);
    }

    public void doClear() {
        this.clear();
    }

    protected String generateChoiceText() {
        if (this.choices.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean insertBreak = false;
        for (IToken token : this.tokens) {
            if (this.choices.contains(token)) {
                if (insertBreak) {
                    sb.append(" ");
                }
                sb.append(token.getSurface());
                insertBreak = false;
            }
            insertBreak |= sb.length() > 0 && token.isFollowedByBreak();
        }
        return sb.toString();
    }

    protected void updateControls() {
        if (this.sentDisplaySync && this.sentDisplay != null) {
            if (!this.sentDisplay.getText().equals(this.tokenText)) {
                this.sentDisplay.setText(this.tokenText);
            }
            this.sentDisplaySync = false;
        }
        if (this.textDisplaySync && this.textDisplay != null) {
            String textToDisplay = this.generateChoiceText();
            if (!this.textDisplay.getText().equals(textToDisplay)) {
                this.textDisplay.setText(textToDisplay);
            }
            this.textDisplaySync = false;
        }
        if (this.addButton != null && !this.addButton.isEnabled()) {
            this.addButton.setEnabled(true);
        }
        if (this.subtractButton != null && this.subtractButton.isEnabled() != this.isSet()) {
            this.subtractButton.setEnabled(this.isSet());
        }
        if (this.clearButton != null && this.clearButton.isEnabled() != this.isSet()) {
            this.clearButton.setEnabled(this.isSet());
        }
    }

    public boolean isSet() {
        return !this.choices.isEmpty();
    }

    public void clear() {
        this.choices.clear();
        this.choices.addAll(this.seeds);
        this.textDisplaySync = true;
        this.updateControls();
        this.notifyChangeListeners((Object)this);
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

