/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.viewers;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.story.ui.StoryUIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTreeViewer
extends Composite
implements PaintListener,
SelectionListener {
    private ITree tree = null;
    private final Canvas canvas;
    private LocatedLayout currentLayout = null;
    private Map<ITree, NodeLayout> layoutCache = new IdentityHashMap<ITree, NodeLayout>();
    private final Point startPoint = new Point(0, 0);
    private final Point scrollPoint = new Point(0, 0);
    protected int minFontSize = 2;
    protected int maxFontSize = 128;
    protected double sisterSkip = 2.5;
    protected double parentSkip = 0.8;
    protected double belowLineSkip = 0.2;
    protected double aboveLineSkip = 0.2;
    private boolean isScrollable = true;

    public ParseTreeViewer(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        this.getHorizontalBar().setVisible(false);
        this.getHorizontalBar().addSelectionListener((SelectionListener)this);
        this.getVerticalBar().setVisible(false);
        this.getVerticalBar().addSelectionListener((SelectionListener)this);
        this.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas((Composite)this, 0x1000000);
        this.canvas.setVisible(true);
        this.canvas.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.canvas.addPaintListener((PaintListener)this);
    }

    public ITree getTree() {
        return this.tree;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public boolean isScrollable() {
        return this.isScrollable;
    }

    public void setTree(ITree tree) {
        this.checkWidget();
        this.tree = tree;
        this.currentLayout = null;
        this.startPoint.x = 0;
        this.startPoint.y = 0;
        this.scrollPoint.x = 0;
        this.scrollPoint.y = 0;
        this.clearLayoutCache();
        this.canvas.redraw();
    }

    public void setScrollable(boolean shouldScroll) {
        this.isScrollable = shouldScroll;
    }

    public void redraw() {
        this.checkWidget();
        this.canvas.redraw();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.canvas.setBackground(color);
    }

    public boolean setFocus() {
        this.checkWidget();
        return (this.getStyle() & 0x80000) == 0 ? this.canvas.setFocus() : false;
    }

    public void widgetSelected(SelectionEvent e) {
        this.checkWidget();
        this.scrollTo(this.getHorizontalBar().getSelection(), this.getVerticalBar().getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.checkWidget();
    }

    public void refresh() {
        this.checkWidget();
        this.setTree(this.tree);
    }

    public void paintControl(PaintEvent e) {
        NodeLayout layout;
        this.checkWidget();
        if (this.tree == null) {
            return;
        }
        Point canvasSize = this.canvas.getSize();
        if (this.currentLayout != null) {
            layout = this.currentLayout.layout;
        } else {
            int fontHeight = e.gc.getFontMetrics().getHeight();
            int nodeXSpacing = (int)(this.sisterSkip * (double)e.gc.stringExtent((String)" ").x);
            int labelPadding = (int)((double)fontHeight * 0.3);
            layout = this.calculateLayout(this.tree, e.gc, 0, 0, fontHeight, labelPadding, nodeXSpacing);
            this.currentLayout = new LocatedLayout(0, 0, layout);
        }
        int width = layout.size.x;
        int height = layout.size.y;
        double startX = (double)(canvasSize.x - width) / 2.0;
        double startY = (double)(canvasSize.y - height) / 2.0;
        if (startX < 0.0) {
            startX = 0.0;
        }
        if (startY < 0.0) {
            startY = 0.0;
        }
        this.startPoint.x = (int)startX;
        this.startPoint.y = (int)startY;
        this.currentLayout.x = this.startPoint.x - this.scrollPoint.x;
        this.currentLayout.y = this.startPoint.y - this.scrollPoint.y;
        if (this.isScrollable & width > canvasSize.x) {
            this.getHorizontalBar().setValues(this.scrollPoint.x, 0, width, this.canvas.getSize().x, width / 100, width / 10);
            this.getHorizontalBar().setVisible(true);
        } else {
            this.getHorizontalBar().setVisible(false);
            this.scrollPoint.x = 0;
        }
        if (this.isScrollable & layout.size.y > canvasSize.y) {
            this.getVerticalBar().setValues(this.scrollPoint.y, 0, height, this.canvas.getSize().y, height / 100, height / 10);
            this.getVerticalBar().setVisible(true);
        } else {
            this.getVerticalBar().setVisible(false);
            this.scrollPoint.y = 0;
        }
        ArrayList<NodeLayout> queue = new ArrayList<NodeLayout>();
        queue.add(layout);
        while (!queue.isEmpty()) {
            int y;
            int x;
            layout = (NodeLayout)queue.remove(0);
            ITree tree = layout.node;
            if (this.configureBorderGC(tree, e.gc)) {
                x = this.currentLayout.x + layout.location.x + layout.nodeBounds.x;
                y = this.currentLayout.y + layout.location.y + layout.nodeBounds.y;
                e.gc.drawRectangle(x, y, layout.nodeBounds.width, layout.nodeBounds.height);
            }
            if (this.configureFillGC(tree, e.gc)) {
                x = this.currentLayout.x + layout.location.x + layout.nodeBounds.x + 1;
                y = this.currentLayout.y + layout.location.y + layout.nodeBounds.y + 1;
                e.gc.fillRectangle(x, y, layout.nodeBounds.width - 1, layout.nodeBounds.height - 1);
            }
            if (this.configureLabelGC(tree, e.gc)) {
                x = this.currentLayout.x + layout.location.x + layout.labelBounds.x;
                y = this.currentLayout.y + layout.location.y + layout.labelBounds.y;
                e.gc.drawString(layout.label, x, y);
            }
            LocatedLayout[] locatedLayoutArray = layout.children;
            int n = layout.children.length;
            int n2 = 0;
            while (n2 < n) {
                LocatedLayout childLocLayout = locatedLayoutArray[n2];
                NodeLayout childLayout = childLocLayout.layout;
                if (this.configureEdgeGC(tree, childLayout.node, e.gc)) {
                    x = this.currentLayout.x + layout.location.x + layout.startEdge.x;
                    y = this.currentLayout.y + layout.location.y + layout.startEdge.y;
                    int endX = this.currentLayout.x + childLayout.location.x + childLayout.endEdge.x;
                    int endY = this.currentLayout.y + childLayout.location.y + childLayout.endEdge.y;
                    e.gc.drawLine(x, y, endX, endY);
                }
                queue.add(childLayout);
                ++n2;
            }
        }
    }

    protected NodeLayout calculateLayout(ITree tree, GC gc, int x, int y, int fontHeight, int labelPadding, int nodeXSpacing) {
        NodeLayout layout = this.fetchLayout(tree);
        if (layout != null) {
            return layout;
        }
        LocatedLayout[] children = new LocatedLayout[tree.getChildren().size()];
        int totalWidth = 0;
        int totalHeight = 0;
        int childrenWidth = 0;
        int childrenHeight = 0;
        int childCeiling = fontHeight + 6 * labelPadding;
        int i = 0;
        while (i < tree.getChildren().size()) {
            ITree child = (ITree)tree.getChildren().get(i);
            NodeLayout childLayout = this.calculateLayout(child, gc, childrenWidth, childCeiling, fontHeight, labelPadding, nodeXSpacing);
            children[i] = new LocatedLayout(childrenWidth, childCeiling, childLayout);
            childrenWidth += childLayout.size.x;
            if (i < tree.getChildren().size() - 1) {
                childrenWidth += nodeXSpacing;
            }
            childrenHeight = Math.max(childrenHeight, childLayout.size.y);
            ++i;
        }
        totalHeight = childrenHeight > 0 ? childrenHeight + childCeiling : fontHeight + 2 * labelPadding;
        Point labelSize = gc.stringExtent(tree.getLabel());
        int nodeX = 0;
        int nodeWidth = labelSize.x + 2 * labelPadding;
        if (nodeWidth > childrenWidth) {
            int rightShift = (int)Math.ceil((nodeWidth - childrenWidth) / 2);
            LocatedLayout[] locatedLayoutArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                LocatedLayout ll = locatedLayoutArray[n2];
                ll.x += rightShift;
                int locX = ll.layout.location.x;
                int locY = ll.layout.location.y;
                ll.layout.setLocation(locX + rightShift, locY);
                ++n2;
            }
            totalWidth = nodeWidth;
        } else {
            totalWidth = childrenWidth;
            nodeX = (childrenWidth - nodeWidth) / 2;
        }
        layout = new NodeLayout(tree, tree.getLabel(), labelPadding, totalWidth, totalHeight, nodeX, 0, labelSize.x, labelSize.y, children);
        layout.setLocation(x, y);
        this.currentLayout = new LocatedLayout(layout);
        this.cacheLayout(tree, layout);
        return layout;
    }

    protected boolean containsPoint(Rectangle bounds, NodeLayout layout, int x, int y) {
        return bounds.contains(this.getLayoutPoint(layout, x, y));
    }

    protected Point getLayoutPoint(NodeLayout layout, int x, int y) {
        int tX = x - this.currentLayout.x - layout.location.x;
        int tY = y - this.currentLayout.y - layout.location.y;
        return new Point(tX, tY);
    }

    protected Rectangle getLayoutBounds(NodeLayout layout, Rectangle bounds) {
        Point tPoint = this.getLayoutPoint(layout, bounds.x, bounds.y);
        return new Rectangle(tPoint.x, tPoint.y, bounds.width, bounds.height);
    }

    protected Point getCanvasPoint(NodeLayout layout, int x, int y) {
        int tX = x + this.currentLayout.x + layout.location.x;
        int tY = y + this.currentLayout.y + layout.location.y;
        return new Point(tX, tY);
    }

    protected Rectangle getCanvasBound(NodeLayout layout, Rectangle bounds) {
        Point tPoint = this.getCanvasPoint(layout, bounds.x, bounds.y);
        return new Rectangle(tPoint.x, tPoint.y, bounds.width, bounds.height);
    }

    protected Rectangle getCanvasNodeBound(ITree node) {
        NodeLayout layout = this.fetchLayout(node);
        if (layout == null) {
            return null;
        }
        return this.getCanvasBound(layout, layout.nodeBounds);
    }

    protected Iterator<Map.Entry<ITree, NodeLayout>> layoutIterator() {
        return this.layoutCache.entrySet().iterator();
    }

    protected NodeLayout fetchLayout(ITree tree) {
        return this.layoutCache.get(tree);
    }

    protected void cacheLayout(ITree tree, NodeLayout layout) {
        this.layoutCache.put(tree, layout);
    }

    protected void clearLayoutCache() {
        this.layoutCache.clear();
        this.currentLayout = null;
    }

    protected String toString(Collection<? extends ITree> nodeCollection) {
        StringBuffer result = new StringBuffer("{");
        Iterator<? extends ITree> i = nodeCollection.iterator();
        while (i.hasNext()) {
            result.append(i.next().getLabel());
            result.append(",");
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        } else {
            result.append("}");
        }
        return result.toString();
    }

    protected boolean configureLabelGC(ITree node, GC gc) {
        gc.setForeground(this.canvas.getForeground());
        gc.setBackground(this.canvas.getBackground());
        gc.setFont(this.canvas.getFont());
        return true;
    }

    protected boolean configureBorderGC(ITree node, GC gc) {
        return false;
    }

    protected boolean configureFillGC(ITree node, GC gc) {
        return false;
    }

    protected boolean configureEdgeGC(ITree parent, ITree child, GC gc) {
        gc.setForeground(this.canvas.getForeground());
        gc.setBackground(this.canvas.getBackground());
        gc.setAntialias(1);
        return true;
    }

    public void scrollTo(int x, int y) {
        this.checkWidget();
        int diffX = this.scrollPoint.x - x;
        int diffY = this.scrollPoint.y - y;
        if (diffX == 0 & diffY == 0) {
            return;
        }
        this.scrollPoint.x = x;
        this.scrollPoint.y = y;
        GC gc = new GC((Drawable)this.canvas);
        gc.copyArea(0, 0, this.canvas.getSize().x, this.canvas.getSize().y, diffX, diffY);
        gc.dispose();
        this.getHorizontalBar().setSelection(x);
        this.getVerticalBar().setSelection(y);
        Control[] controlArray = this.canvas.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point location = child.getLocation();
            child.setLocation(location.x + diffX, location.y + diffY);
            ++n2;
        }
    }

    protected class LocatedLayout {
        int x = 0;
        int y = 0;
        final NodeLayout layout;

        public LocatedLayout(NodeLayout layout) {
            this.layout = layout;
        }

        public LocatedLayout(int x, int y, NodeLayout layout) {
            this.x = x;
            this.y = y;
            this.layout = layout;
        }
    }

    protected class NodeLayout {
        final ITree node;
        final String label;
        final Point size;
        final Rectangle labelBounds;
        final Rectangle nodeBounds;
        final Point startEdge;
        final Point endEdge;
        final LocatedLayout[] children;
        Point location = null;

        public NodeLayout(ITree tree, String label, int labelPadding, int width, int height, int nodeX, int nodeY, int labelW, int labelH, LocatedLayout[] children) {
            this.node = tree;
            this.label = label;
            this.size = new Point(width, height);
            this.labelBounds = new Rectangle(nodeX + labelPadding, nodeY + labelPadding, labelW, labelH);
            this.nodeBounds = new Rectangle(nodeX, nodeY, labelW + 2 * labelPadding, labelH + 2 * labelPadding);
            this.endEdge = new Point(width / 2, 0);
            this.startEdge = new Point(width / 2, labelH + 2 * labelPadding);
            this.children = children;
        }

        public Rectangle getBounds() {
            return new Rectangle(0, 0, this.size.x, this.size.y);
        }

        public void setLocation(int x, int y) {
            this.location = new Point(x, y);
            LocatedLayout[] locatedLayoutArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                LocatedLayout childLocLayout = locatedLayoutArray[n2];
                childLocLayout.layout.setLocation(x + childLocLayout.x, y + childLocLayout.y);
                ++n2;
            }
        }

        public String toString() {
            String result = String.valueOf(this.label) + ": size=" + this.size + "; labelBounds=" + this.labelBounds + "; nodeBounds = " + this.nodeBounds + "; startEdge=" + this.startEdge + "; endEdge=" + this.endEdge + "; location=" + this.location + "; childrenLocations=";
            int i = 0;
            while (i < this.children.length) {
                LocatedLayout ll = this.children[i];
                result = String.valueOf(result) + "(" + ll.x + "," + ll.y + ")";
                if (i < this.children.length - 2) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
            return result;
        }
    }
}

