/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.viewers;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.ui.viewers.ParseTreeViewer;
import edu.mit.story.ui.StoryUIPlugin;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParseTreeSelectableViewer
extends ParseTreeViewer
implements MouseMoveListener,
MouseListener,
KeyListener,
ISelectionProvider {
    private boolean isSelectable = true;
    private boolean isEditable = false;
    private ITree nodeUnderCursor = null;
    private ITree selectedNode = null;
    private ISelection currentSelection = null;
    private ListenerList selectionChangedListeners = new ListenerList();
    private RenamingBox renamingBox = null;
    private final Cursor CURSOR_NORMAL;
    private final Cursor CURSOR_NOT_ALLOWED;
    private final Cursor CURSOR_DRAGGING;
    private final Color COLOR_SELECT;
    private final Color COLOR_LINE;
    private final Color COLOR_BACKGROUND;
    private final int[] dashes = new int[]{1, 1};
    private ParseTreeState state = ParseTreeState.NORMAL;

    public ParseTreeSelectableViewer(Composite parent, int style) {
        super(parent, style);
        this.CURSOR_NORMAL = new Cursor((Device)parent.getDisplay(), 0);
        this.CURSOR_NOT_ALLOWED = new Cursor((Device)parent.getDisplay(), 20);
        this.CURSOR_DRAGGING = new Cursor((Device)parent.getDisplay(), 21);
        this.COLOR_SELECT = StoryUIPlugin.getDefault().getColorManager().get((Object)"DARK_BLUE");
        this.COLOR_LINE = StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK");
        this.COLOR_BACKGROUND = StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE");
        this.getCanvas().addMouseMoveListener((MouseMoveListener)this);
        this.getCanvas().addMouseListener((MouseListener)this);
        this.getCanvas().addKeyListener((KeyListener)this);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean value) {
        this.isEditable = value;
        if (value) {
            this.setSelectable(value);
        }
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean value) {
        this.isSelectable = value;
    }

    private ParseTreeState getState() {
        return this.state;
    }

    private void setState(ParseTreeState newState) {
        if (newState == ParseTreeState.NORMAL) {
            this.setCursor(this.CURSOR_NORMAL);
        }
        this.state = newState;
    }

    public void setTree(ITree tree) {
        this.endRenameOperation();
        this.nodeUnderCursor = null;
        this.selectedNode = null;
        this.currentSelection = StructuredSelection.EMPTY;
        super.setTree(tree);
        this.fireSelectionChanged();
    }

    public void setSelectedTree(ITree nodeToSelect) {
        this.selectedNode = nodeToSelect;
        this.currentSelection = this.selectedNode == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.selectedNode);
        this.redraw();
        this.fireSelectionChanged();
    }

    public ITree getSelectedTree() {
        return this.selectedNode;
    }

    public boolean isTreeSelected(ITree tree) {
        return tree != null && this.selectedNode != null && this.selectedNode == tree;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
    }

    protected void fireSelectionChanged() {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public ITree getNodeUnderCursor() {
        return this.nodeUnderCursor;
    }

    public boolean isUnderCursor(ITree tree) {
        return tree != null && this.nodeUnderCursor != null && tree == this.nodeUnderCursor;
    }

    public boolean canDoDrop() {
        return false;
    }

    public void keyPressed(KeyEvent e) {
        if (!this.isSelectable) {
            return;
        }
        if (this.selectedNode == null) {
            switch (e.keyCode) {
                case 0x1000002: {
                    this.setSelectedTree(this.getTree());
                    break;
                }
                case 0x1000003: {
                    List leaves = this.getTree().getLeaves();
                    this.setSelectedTree((ITree)leaves.get(leaves.size() - 1));
                    break;
                }
                case 0x1000004: {
                    List leaves = this.getTree().getLeaves();
                    this.setSelectedTree((ITree)leaves.get(0));
                }
            }
            return;
        }
        switch (e.keyCode) {
            case 0x1000001: {
                if (this.selectedNode.getParent() == null) break;
                this.setSelectedTree(this.selectedNode.getParent());
                break;
            }
            case 0x1000002: {
                if (this.selectedNode.isLeaf()) break;
                this.setSelectedTree((ITree)this.selectedNode.getChildren().get(0));
                break;
            }
            case 0x1000003: {
                int depth = 1;
                int i = 0;
                ITree child = this.selectedNode;
                ITree parent = this.selectedNode.getParent();
                while (parent != null) {
                    i = parent.getChildren().indexOf(child);
                    if (i > 0) break;
                    ++depth;
                    child = parent;
                    parent = child.getParent();
                }
                if (parent == null || i <= 0) break;
                child = (ITree)parent.getChildren().get(--i);
                while (child.getChildren().size() > 0 & depth > 1) {
                    child = (ITree)child.getChildren().get(child.getChildren().size() - 1);
                    --depth;
                }
                this.setSelectedTree(child);
                break;
            }
            case 0x1000004: {
                int depth = 1;
                int i = 0;
                ITree child = this.selectedNode;
                ITree parent = this.selectedNode.getParent();
                while (parent != null) {
                    i = parent.getChildren().indexOf(child);
                    if (parent.getChildren().size() - 1 > i) break;
                    ++depth;
                    child = parent;
                    parent = child.getParent();
                }
                if (parent == null || i >= parent.getChildren().size() - 1) break;
                child = (ITree)parent.getChildren().get(++i);
                while (child.getChildren().size() > 0 & depth > 1) {
                    child = (ITree)child.getChildren().get(0);
                    --depth;
                }
                this.setSelectedTree(child);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1 || !this.isSelectable) {
            return;
        }
        this.mouseMoved(e);
        if (this.isSelectable && this.getState() == ParseTreeState.NORMAL && this.nodeUnderCursor != this.selectedNode) {
            this.setSelectedTree(this.nodeUnderCursor);
            if (this.selectedNode != null) {
                this.setState(ParseTreeState.SELECTING);
            } else {
                this.setState(ParseTreeState.NORMAL);
            }
        } else if (this.isEditable && this.getState() == ParseTreeState.NORMAL && this.nodeUnderCursor == this.selectedNode) {
            this.setState(ParseTreeState.SELECTING_AGAIN);
        } else {
            this.getState();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1 || !this.isSelectable) {
            return;
        }
        this.mouseMoved(e);
        this.getState();
        this.getState();
        if (this.getState() != ParseTreeState.RENAMING) {
            this.setState(ParseTreeState.NORMAL);
        }
    }

    public void mouseMove(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        ITree newNodeUnderCursor = null;
        ParseTreeViewer.NodeLayout layout = null;
        Iterator<Map.Entry<ITree, ParseTreeViewer.NodeLayout>> i = this.layoutIterator();
        while (i.hasNext()) {
            Map.Entry<ITree, ParseTreeViewer.NodeLayout> entry = i.next();
            layout = entry.getValue();
            if (!this.containsPoint(layout.nodeBounds, layout, e.x, e.y)) continue;
            newNodeUnderCursor = entry.getKey();
            break;
        }
        if (this.getState() == ParseTreeState.NORMAL | this.getState() == ParseTreeState.RENAMING) {
            this.setCursor(this.CURSOR_NORMAL);
        }
        if (this.getState() == ParseTreeState.SELECTING | this.getState() == ParseTreeState.SELECTING_AGAIN) {
            this.setState(ParseTreeState.DRAGGING);
        }
        if (this.getState() == ParseTreeState.DRAGGING & this.isEditable()) {
            if (!this.canDoDrop()) {
                this.setCursor(this.CURSOR_NOT_ALLOWED);
            } else {
                this.setCursor(this.CURSOR_DRAGGING);
            }
            boolean shouldColor = true;
            boolean shouldDecolor = true;
            if (this.selectedNode != null) {
                if (this.isTreeSelected(this.nodeUnderCursor)) {
                    shouldDecolor = false;
                }
                if (this.isTreeSelected(newNodeUnderCursor)) {
                    shouldColor = false;
                }
            }
            if (newNodeUnderCursor == null) {
                if (this.nodeUnderCursor != null && shouldDecolor) {
                    Rectangle oldBounds = this.getCanvasNodeBound(this.nodeUnderCursor);
                    this.getCanvas().redraw(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, true);
                }
            } else if (this.nodeUnderCursor == null) {
                if (shouldColor) {
                    Rectangle newBounds = this.getCanvasNodeBound(newNodeUnderCursor);
                    this.getCanvas().redraw(newBounds.x, newBounds.y, newBounds.width, newBounds.height, true);
                }
            } else if (newNodeUnderCursor != this.nodeUnderCursor) {
                if (shouldDecolor) {
                    Rectangle oldBounds = this.getCanvasNodeBound(this.nodeUnderCursor);
                    this.getCanvas().redraw(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height, true);
                }
                if (shouldColor) {
                    Rectangle newBounds = this.getCanvasNodeBound(newNodeUnderCursor);
                    this.getCanvas().redraw(newBounds.x, newBounds.y, newBounds.width, newBounds.height, true);
                }
            }
        }
        this.nodeUnderCursor = newNodeUnderCursor;
    }

    public void startRenameOperation(ITree node) {
        if (this.getState() == ParseTreeState.RENAMING) {
            return;
        }
        if (node == null) {
            return;
        }
        if (this.renamingBox == null) {
            this.renamingBox = new RenamingBox((Composite)this.getCanvas());
        }
        this.renamingBox.configureBox(node);
        this.renamingBox.setVisible(true);
        this.renamingBox.setFocus();
        this.setState(ParseTreeState.RENAMING);
    }

    public void endRenameOperation() {
        if (this.getState() != ParseTreeState.RENAMING) {
            return;
        }
        this.renamingBox.setVisible(false);
        this.setState(ParseTreeState.NORMAL);
    }

    public boolean insert(ITree parent, ITree child, int index, boolean pushSideways) {
        return false;
    }

    public boolean move(ITree target, ITree child, int targetIndex) {
        return false;
    }

    public int delete(ITree child) {
        return -1;
    }

    public boolean rename(ITree node, String newName) {
        return false;
    }

    public boolean configureLabelGC(ITree node, GC gc) {
        if (this.isTreeSelected(node)) {
            gc.setBackground(this.COLOR_SELECT);
            gc.setForeground(this.getCanvas().getBackground());
        } else if (this.isUnderCursor(node) & this.getState() == ParseTreeState.DRAGGING) {
            gc.setBackground(this.COLOR_SELECT);
            gc.setForeground(this.getCanvas().getBackground());
        } else {
            gc.setBackground(this.getCanvas().getBackground());
            gc.setForeground(this.getCanvas().getForeground());
        }
        return true;
    }

    public boolean configureBorderGC(ITree node, GC gc) {
        if (this.isTreeSelected(node)) {
            gc.setBackground(this.getCanvas().getBackground());
            gc.setForeground(this.COLOR_LINE);
            gc.setLineDash(this.dashes);
            gc.setAntialias(0);
            return true;
        }
        return false;
    }

    public boolean configureFillGC(ITree node, GC gc) {
        if (this.isTreeSelected(node)) {
            gc.setBackground(this.COLOR_SELECT);
            return true;
        }
        if (this.isUnderCursor(node) & this.getState() == ParseTreeState.DRAGGING) {
            gc.setBackground(this.COLOR_SELECT);
            return true;
        }
        return false;
    }

    public boolean configureEdgeGC(ITree parent, ITree child, GC gc) {
        gc.setForeground(this.getCanvas().getForeground());
        gc.setBackground(this.getCanvas().getBackground());
        gc.setLineStyle(1);
        gc.setAntialias(1);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseTreeState {
        NORMAL("NORMAL"),
        DRAGGING("DRAGGING"),
        RENAMING("RENAMING"),
        SELECTING("SELECTING"),
        SELECTING_AGAIN("SELECTING_AGAIN");

        final String display;

        private ParseTreeState(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }

    protected class RenamingBox
    extends Composite
    implements KeyListener,
    MouseMoveListener {
        Text input;
        Rectangle originalBounds;
        int offset;

        public RenamingBox(Composite parent) {
            super(parent, 0);
            this.input = null;
            this.originalBounds = null;
            this.offset = 0;
            FillLayout layout = new FillLayout();
            layout.marginWidth = 1;
            layout.marginHeight = 1;
            this.setBackground(ParseTreeSelectableViewer.this.COLOR_LINE);
            this.setLayout((Layout)layout);
            this.addMouseMoveListener(this);
            this.input = new Text((Composite)this, 0);
            this.input.setBackground(ParseTreeSelectableViewer.this.COLOR_BACKGROUND);
            this.input.addKeyListener((KeyListener)this);
            this.input.addMouseMoveListener((MouseMoveListener)this);
        }

        public void configureBox(ITree node) {
            if (node == null) {
                return;
            }
            this.originalBounds = ParseTreeSelectableViewer.this.getCanvasNodeBound(ParseTreeSelectableViewer.this.selectedNode);
            this.setBounds(this.originalBounds.x, this.originalBounds.y, this.originalBounds.width + 15, this.originalBounds.height + 1);
            this.input.setText(ParseTreeSelectableViewer.this.selectedNode.getLabel());
            int textLength = this.input.getText().length();
            this.input.setSelection(0, textLength);
            int i = 0;
            while (i < textLength) {
                this.input.traverse(64);
                ++i;
            }
            this.input.setFocus();
            this.input.setVisible(true);
        }

        public String getText() {
            return this.input.getText();
        }

        public void keyPressed(KeyEvent e) {
            GC gc = new GC((Drawable)this.input);
            String text = this.input.getText();
            if (e.keyCode == 8) {
                if (text.length() > 2) {
                    text = text.substring(0, text.length() - 2);
                }
            } else if (e.keyCode != 27 & e.keyCode != 13) {
                text = String.valueOf(text) + e.character;
            }
            Point labelSize = gc.stringExtent(text);
            int newWidth = labelSize.x + 10;
            if (newWidth < this.originalBounds.width + 15) {
                newWidth = this.originalBounds.width + 15;
            }
            this.setBounds(this.originalBounds.x, this.originalBounds.y, newWidth, this.originalBounds.height + 1);
            this.redraw();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            if (ParseTreeSelectableViewer.this.getState() == ParseTreeState.NORMAL | ParseTreeSelectableViewer.this.getState() == ParseTreeState.RENAMING) {
                this.setCursor(ParseTreeSelectableViewer.this.CURSOR_NORMAL);
            }
        }
    }
}

