/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.helpers;

import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagDataModel;
import edu.mit.parsing.ui.controllers.ITagDataController;
import edu.mit.parsing.ui.controllers.TagDataController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class TagDataCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable,
ChangeListener {
    public static final String ID = TagDataCreatorPage.class.getName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Tag";
    public static String buttonLabelSaveArg = "Save Tag";
    public static String actionLabelCommit = "Commit Tag";
    public static String actionLabelSave = "Save Tag";
    public static String actionLabelClear = "Clear Tag";
    public static String actionLabelCancel = "Cancel Edit";
    public static String actionLabelCommitArg = "Commit Tag";
    public static String actionLabelSaveArg = "Save Changes in Tag";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new tag", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this tag to the model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this tag in the model", 1);
    public static IMessageProvider saveArgMessage = new Message("Press the 'save tag' button to change this tag", 2);
    protected ITagDataController controller;
    protected IModelListener modelListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (TagDataCreatorPage.this.getControl().isDisposed()) {
                return;
            }
            if (e.affects(TagRep.getInstance())) {
                TagDataCreatorPage.this.updateFromModel();
            }
        }
    };
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected ComboViewer tagCombo;
    protected SegmentSetCaptureWidget<ITagDataController> extentWidget;
    protected Label descLabel;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)TagDataCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.setControl((Control)control);
        this.controller = new TagDataController(this.getStoryEditor(), "edu.mit.story.ui.annotation.target1");
        IUndoableStoryModel storyModel = this.getStoryEditor().getStoryModel();
        storyModel.addModelListener(this.modelListener);
        this.messageManager = new MessageProviderManager();
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel());
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TagDataCreatorPage.this.updateFromModel();
            }
        });
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)this.messageBar);
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputParent = new Composite(control, 0);
        inputParent.setLayoutData((Object)new GridData(4, 0, true, false));
        inputParent.setLayout((Layout)new GridLayout(3, false));
        ColorManager.inheritColors((Control)inputParent);
        Label label = new Label(inputParent, 0);
        label.setText("Tag");
        ColorManager.inheritColors((Control)label);
        this.tagCombo = new ComboViewer(new CCombo(inputParent, 2048));
        ColorManager.inheritColors((Control)this.tagCombo.getControl());
        this.tagCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tagCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.tagCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITag tag = (ITag)SelectionUtils.extractSingle((ISelection)event.getSelection(), ITag.class);
                if (tag != null) {
                    TagDataCreatorPage.this.controller.setID(tag.getID());
                }
            }
        });
        this.tagCombo.getCCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tagID = TagDataCreatorPage.this.tagCombo.getCCombo().getText();
                if (tagID.length() != 0) {
                    TagDataCreatorPage.this.controller.setID(tagID);
                }
            }
        });
        this.extentWidget = new SegmentSetCaptureWidget<ITagDataController>(inputParent, 0, this.controller);
        this.extentWidget.setLayoutData(new GridData(4, 0, true, false));
        this.extentWidget.getAddAction().setText("Add to Tag");
        this.extentWidget.getAddAction().setToolTipText("Add to Tag");
        this.extentWidget.getSubtractAction().setText("Subtract from Tag");
        this.extentWidget.getSubtractAction().setToolTipText("Subtract from Tag");
        this.extentWidget.getClearAction().setText("Clear Tag");
        this.extentWidget.getClearAction().setToolTipText("Clear Tag");
        new Label(inputParent, 0);
        Label descLabelLabel = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)descLabelLabel);
        descLabelLabel.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
        descLabelLabel.setText("Description:");
        this.descLabel = new Label(inputParent, 64);
        ColorManager.inheritColors((Control)this.descLabel);
        this.descLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        label = new Label(inputParent, 0);
        ColorManager.inheritColors((Control)label);
        Composite buttonParent = new Composite(inputParent, 0);
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        ColorManager.inheritColors((Control)buttonParent);
        label = new Label(buttonParent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ColorManager.inheritColors((Control)label);
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                TagDataCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                TagDataCreatorPage.this.controller.clear();
            }
        };
        this.messageManager = new MessageProviderManager(createMessage, (ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.updateFromModel();
    }

    public void stateChanged(ChangeEvent event) {
        this.updateFromModel();
    }

    public void setActionBars(IActionBars actionBars) {
        this.extentWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.extentWidget.getAddAction().getActionDefinitionId(), this.extentWidget.getAddAction());
        this.extentWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        actionBars.setGlobalActionHandler(this.extentWidget.getSubtractAction().getActionDefinitionId(), this.extentWidget.getSubtractAction());
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
    }

    protected void updateFromModel() {
        ITag tag;
        String clearActionLabel;
        IMessageProvider defaultMsg;
        ITagDataModel model = this.controller.getModel();
        boolean isMainLoaded = model.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isMainLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableCommit = !model.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !model.isCleared() || !model.isCleared();
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String string = clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (this.tagCombo.getInput() != model.getTagset()) {
            ITagset tagset = model.getTagset();
            int tagsetSize = tagset == null ? 10 : tagset.size();
            this.tagCombo.setInput((Object)tagset);
            this.tagCombo.getCCombo().setVisibleItemCount(Math.min(10, tagsetSize));
        }
        if ((tag = model.getTag()).getTagSet() == null) {
            if (!this.tagCombo.getCCombo().getText().equals(tag.getID())) {
                this.tagCombo.getCCombo().setText(tag.getID());
            }
        } else {
            StructuredSelection tagSel = new StructuredSelection((Object)tag);
            if (!this.tagCombo.getSelection().equals(tagSel)) {
                this.tagCombo.setSelection((ISelection)tagSel);
            }
        }
        this.descLabel.setText(tag.getDescription());
        this.descLabel.setToolTipText("Tag: " + model.getTag().getName());
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public ITagDataController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        this.getStoryEditor().getStoryModel().removeModelListener(this.modelListener);
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

