/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.handlers;

import edu.mit.parsing.core.rep.pos.AssignPOSChange;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.parsing.ui.dialogs.POSTagChooserDialog;
import edu.mit.parsing.ui.dialogs.WordSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AssignPOSHandler
extends AbstractHandler {
    public void setEnabled(Object context) {
        EvaluationContext evalContext;
        Object var;
        if (context instanceof EvaluationContext && (var = (evalContext = (EvaluationContext)context).getVariable("activeEditor")) instanceof IStoryEditor) {
            IStoryEditor editor = (IStoryEditor)var;
            IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
            this.setBaseEnabled(!tokens.isEmpty());
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Date start = new Date();
        IStoryEditor editor = (IStoryEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)editor);
        if (tokens.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().beep();
            return null;
        }
        IDesc word = WordSelectionDialog.open(editor);
        if (word == null) {
            return null;
        }
        IDescSet ds = editor.getStoryModel().getData().getDescriptions(POSRep.getInstance()).matchSet((IHasPosition)word);
        IPosTag selTag = null;
        for (IDesc d : ds) {
            IPosTag tag = (IPosTag)d.getData();
            if (tag.getWord().getID() != word.getID()) continue;
            if (selTag != null) {
                selTag = null;
                break;
            }
            selTag = tag;
        }
        IPosData newTag = POSTagChooserDialog.open(editor.getSite().getShell(), POSTagChooserDialog.Filter.TOKENS, selTag);
        if (newTag == null) {
            return null;
        }
        editor.getStoryModel().applyChange((Object)this, (IModelChange)new AssignPOSChange(newTag, word, (ITiming)new Timing(start, ((Object)((Object)this)).getClass().getCanonicalName())), false);
        return null;
    }
}

