/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.dialogs;

import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.core.rep.stem.StemData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.ui.ParsingUIMessages;
import edu.mit.story.core.util.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class StemSpecificationDialog
extends InputDialog {
    public static final int DELETE = -1;
    private final boolean allowDelete;

    protected StemSpecificationDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        this(parentShell, dialogTitle, dialogMessage, initialValue, validator, false);
    }

    protected StemSpecificationDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, boolean allowDelete) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        this.allowDelete = allowDelete;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.allowDelete) {
            this.createButton(parent, -1, "Delete", false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == -1) {
            this.deletePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void deletePressed() {
        this.setReturnCode(-1);
        this.close();
    }

    public static StemSpecificationDialog create(Shell shell, IBaseWordInfo info) {
        return StemSpecificationDialog.create(shell, info, false);
    }

    public static StemSpecificationDialog create(Shell shell, IBaseWordInfo info, boolean allowDelete) {
        IPosData tag = info.getPosTag();
        if (tag == null) {
            tag = new PosData((ITag)PennTag.UNKNOWN, false);
        }
        Object[] bindings = new String[]{info.getBaseToken().getSurface(), tag.getTag().getTagString(), tag.getTag().getName()};
        String message = NLS.bind((String)ParsingUIMessages.MSG_PleaseChooseStem, (Object[])bindings);
        String initial = info.getStem() == null ? info.getBaseToken().getSurface() : info.getStem().getStem();
        StemSpecificationDialog dialog = new StemSpecificationDialog(shell, "Specify Stem", message, initial, new StemValidator(initial), allowDelete);
        dialog.setBlockOnOpen(true);
        return dialog;
    }

    public static StemData open(Shell shell, IBaseWordInfo info) {
        StemSpecificationDialog dialog = StemSpecificationDialog.create(shell, info, false);
        dialog.open();
        return dialog.getReturnCode() == 0 ? new StemData(dialog.getValue()) : null;
    }

    public static class StemValidator
    implements IInputValidator {
        final String oldString;

        public StemValidator(String oldString) {
            if (StringUtils.isEmpty((String)oldString)) {
                throw new IllegalArgumentException();
            }
            this.oldString = oldString;
        }

        public String isValid(String newText) {
            return StringUtils.isEmpty((String)newText) ? "New stem cannot be empty" : null;
        }
    }
}

