/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.controllers;

import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagDataModel;
import edu.mit.parsing.core.rep.tag.tagset.models.TagDataModel;
import edu.mit.parsing.ui.controllers.ITagDataController;
import edu.mit.parsing.ui.controllers.SegmentSetController;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;

public class TagDataController
extends SegmentSetController
implements ITagDataController {
    public TagDataController(IStoryEditor editor, String annoID) {
        super((ISegmentSetModel)new TagDataModel((IStoryModel)editor.getStoryModel()), editor, annoID);
    }

    public ITagDataModel getModel() {
        return (ITagDataModel)super.getModel();
    }

    public void setID(String tagID) {
        this.getModel().setTagID(tagID);
    }

    public void commit() {
        long id;
        ITagDataModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing editTime = new Timing(model.getStart(), "user");
        ITagData tagData = model.create();
        IHasPosition p = tagData.calculatePosition();
        IDesc oldDesc = model.getLoaded();
        IMetaDataMap metadata = null;
        if (oldDesc == null) {
            id = this.getStoryEditor().getStoryModel().getNextID();
        } else {
            id = oldDesc.getID();
            metadata = oldDesc.getMetaData();
        }
        Desc newDesc = new Desc(id, TagRep.getInstance(), p, (IData)tagData, (Iterable)metadata);
        newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
        newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)editTime));
        AddDescriptionsChange change = new AddDescriptionsChange((IDesc)newDesc);
        if (oldDesc != null) {
            change = new CompositeModelChange(new IModelChange[]{new RemoveDescriptionsChange(oldDesc), change});
        }
        this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        this.clear();
    }

    public void edit(IDesc desc) {
        this.getModel().load(desc);
    }

    public void load(IDesc desc) {
        this.getModel().load(desc);
    }
}

