/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.actions;

import edu.mit.parsing.core.rep.tag.TagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collections;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class CreateTagDataMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    public static final String COMMAND_ID_CreateTag = "edu.mit.parsing.command.createTag";
    protected IStoryEditor editor;

    public CreateTagDataMenu() {
    }

    public CreateTagDataMenu(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ITagset tagset = TagRep.getTagset((IStoryModel)this.editor.getStoryModel());
        if (tagset == null) {
            ActionContributionItem disabledItem = new ActionContributionItem((IAction)new NoTagsAction());
            return new IContributionItem[]{disabledItem};
        }
        IContributionItem[] items = new IContributionItem[tagset.size()];
        int i = 0;
        for (ITag tag : tagset) {
            items[i++] = new ActionContributionItem((IAction)new CreateTagAction(tag));
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        IWorkbenchPartSite partSite = (IWorkbenchPartSite)serviceLocator.getService(IWorkbenchPartSite.class);
        IWorkbenchPart part = partSite.getPart();
        if (part instanceof IStoryEditor) {
            this.editor = (IStoryEditor)part;
        }
    }

    public class CreateTagAction
    extends Action {
        private final ITag tag;

        public CreateTagAction(ITag tag) {
            if (tag == null) {
                throw new NullPointerException();
            }
            this.tag = tag;
        }

        public String getText() {
            return this.tag.getName();
        }

        public String getDescription() {
            return this.tag.getDescription();
        }

        public String getToolTipText() {
            return this.tag.getDescription();
        }

        public void run() {
            Date start = new Date();
            IDescSet tokens = ParsingUtils.getTokens((IHasPosition)CreateTagDataMenu.this.editor.getSelectedRange(), (IStoryData)CreateTagDataMenu.this.editor.getStoryModel().getData());
            if (tokens.isEmpty()) {
                return;
            }
            Segment seg = new Segment((IHasPosition)tokens, TokenRep.getInstance(), CreateTagDataMenu.this.editor.getStoryModel().getData());
            TagData data = new TagData(this.tag.getID(), Collections.singleton(seg));
            IHasPosition p = data.calculatePosition();
            long id = CreateTagDataMenu.this.editor.getStoryModel().getNextID();
            Desc desc = new Desc(id, TagRep.getInstance(), p, (IData)data, null);
            desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)desc, (IMetaData)Origin.USER_SPECIFIED));
            desc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)desc, (IMetaData)new Timing(start, "user")));
            CreateTagDataMenu.this.editor.getStoryModel().applyChange((Object)this, (IModelChange)new AddDescriptionsChange((IDesc)desc), false);
        }
    }

    public class NoTagsAction
    extends Action {
        public String getText() {
            return "No Tags Available";
        }

        public String getToolTipText() {
            return "No tags are currently available";
        }

        public boolean isEnabled() {
            return false;
        }
    }
}

