/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.datamodel.IResourcePairModel;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.controllers.IResourcePairController;
import edu.mit.story.ui.util.ColorManager;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePairSelectionPage
extends WizardPage {
    public static final String NAME = ResourcePairSelectionPage.class.getSimpleName();
    protected final IResourcePairController<? extends IResourcePairModel> controller;
    protected Text sourceBox;
    protected Text sourceTagBox;
    protected Text targetBox;
    protected Text targetTagBox;
    protected FileDialog chooser;

    public ResourcePairSelectionPage(IResourcePairController<? extends IResourcePairModel> controller) {
        this(NAME, controller);
    }

    protected ResourcePairSelectionPage(String pageName, IResourcePairController<? extends IResourcePairModel> controller) {
        super(pageName);
        if (controller == null) {
            throw new NullPointerException();
        }
        this.setTitle("Select Source and Target");
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        this.setControl((Control)parent);
        parent.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(parent, 0);
        label.setText("Source:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        this.sourceBox = new Text(parent, 2048);
        this.sourceBox.setEditable(false);
        this.sourceBox.setBackground(Display.getDefault().getSystemColor(25));
        this.sourceBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button browse = new Button(parent, 0);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = ResourcePairSelectionPage.this.selectFile("Source", false);
                if (file != null) {
                    ResourcePairSelectionPage.this.controller.setSource(file);
                }
            }
        });
        new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText("Label:");
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.sourceTagBox = new Text(parent, 2048);
        this.sourceTagBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sourceTagBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcePairSelectionPage.this.controller.setSourceTag(ResourcePairSelectionPage.this.sourceTagBox.getText());
            }
        });
        Button switchButton = new Button(parent, 8);
        switchButton.setImage(StoryUIPlugin.getDefault().getImageRegistry().get("elcl16/switch.gif"));
        switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcePairSelectionPage.this.controller.switchResources();
            }
        });
        label = new Label(parent, 0);
        label.setText("Target:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        this.targetBox = new Text(parent, 2048);
        this.targetBox.setEditable(false);
        this.targetBox.setBackground(Display.getDefault().getSystemColor(25));
        this.targetBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        browse = new Button(parent, 0);
        browse.setText("Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = ResourcePairSelectionPage.this.selectFile("Target", false);
                if (file != null) {
                    ResourcePairSelectionPage.this.controller.setTarget(file);
                }
            }
        });
        new Label(parent, 0);
        label = new Label(parent, 0);
        label.setText("Label:");
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.targetTagBox = new Text(parent, 2048);
        this.targetTagBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.targetTagBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcePairSelectionPage.this.controller.setTargetTag(ResourcePairSelectionPage.this.targetTagBox.getText());
            }
        });
        new Label(parent, 0);
        this.controller.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ResourcePairSelectionPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected File selectFile(String title, boolean save) {
        String filterPath = this.getFilterPath();
        this.chooser = this.createChooser(title, save);
        this.chooser.setFilterPath(filterPath);
        String filename = null;
        File file = this.controller.getModel().getSourceFile();
        if (file != null) {
            filename = file.getName();
        }
        if ((file = this.controller.getModel().getSourceFile()) != null) {
            filename = file.getName();
        }
        if (filename != null) {
            this.chooser.setFileName(filename);
        }
        if (this.chooser.open() == null) {
            return null;
        }
        IPath path = new Path(this.chooser.getFilterPath()).append(this.chooser.getFileName());
        if (save) {
            String sty = "sty";
            if (!path.getFileExtension().equals(sty)) {
                path.addFileExtension(sty);
            }
        }
        return path.toFile();
    }

    protected String getFilterPath() {
        if (this.chooser != null) {
            return this.chooser.getFilterPath();
        }
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        return path == null ? null : path.toOSString();
    }

    protected FileDialog createChooser(String type, boolean save) {
        FileDialog dialog = new FileDialog(this.getShell(), save ? 8192 : 4096);
        dialog.setText("Select the " + type + " file");
        String styFilter = "*.sty";
        String allFilter = "*.*";
        String styName = "Story Files (" + styFilter + ")";
        String allName = "All Files (" + allFilter + ")";
        dialog.setFilterExtensions(new String[]{styFilter, allFilter});
        dialog.setFilterNames(new String[]{styName, allName});
        dialog.setOverwrite(save);
        return dialog;
    }

    protected void updateFromModel() {
        String targetPath;
        IResourcePairModel model = this.controller.getModel();
        File file = model.getSourceFile();
        String sourcePath = file == null ? "" : file.getAbsolutePath();
        file = model.getTargetFile();
        String string = targetPath = file == null ? "" : file.getAbsolutePath();
        if (!this.sourceBox.getText().equals(sourcePath)) {
            this.sourceBox.setText(sourcePath);
            this.sourceBox.setSelection(sourcePath.length());
        }
        if (!this.targetBox.getText().equals(targetPath)) {
            this.targetBox.setText(targetPath);
            this.targetBox.setSelection(targetPath.length());
        }
        String tag = model.getSourceTag();
        if (!this.sourceTagBox.getText().equals(tag)) {
            this.sourceTagBox.setText(tag);
            this.sourceTagBox.setSelection(tag.length());
        }
        tag = model.getTargetTag();
        if (!this.targetTagBox.getText().equals(tag)) {
            this.targetTagBox.setText(tag);
            this.targetTagBox.setSelection(tag.length());
        }
        boolean error = !model.isCleared() && model.getMessageType() == 3;
        this.setErrorMessage(error ? model.getMessage() : null);
        this.setPageComplete(!error);
    }
}

