/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.ExistingFileValidator;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.widgets.PathSpecificationGroup;
import edu.mit.story.ui.widgets.RadioButtonEnumGroup;
import edu.mit.story.ui.wizards.page.NewStoryPage;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImportTextPage
extends NewStoryPage
implements ChangeListener {
    public static final String NAME = StringUtils.getClassName(ImportTextPage.class);
    protected PathSpecificationGroup pathGroup;
    protected RadioButtonEnumGroup<ImportType> buttonGroup;

    public ImportTextPage() {
        this.setTitle(StoryUIMessages.WIZARD_PAGE_ImportText_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_ImportText_description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.pathGroup = new PathSpecificationGroup(this.filenameGroup, StoryUIMessages.WIZARD_PAGE_ImportSourceFileEntry_label, (IValidator<String>)new ExistingFileValidator());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.pathGroup.setLayoutData(data);
        this.manager.add((INotifyingMessageProvider)this.pathGroup);
        Label spacer = new Label((Composite)this.pathGroup, 0);
        spacer.setText(StoryUIMessages.WIZARD_PAGE_ImportSourceFileEntry_type);
        this.buttonGroup = new RadioButtonEnumGroup<ImportType>(ImportType.class);
        this.buttonGroup.setUseGroup(false);
        this.buttonGroup.createComposite(this.pathGroup, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.buttonGroup.getComposite().setLayoutData((Object)data);
        this.manager.add(this.buttonGroup);
    }

    public IPath getSourcePath() {
        return this.pathGroup.getFilePath();
    }

    public ImportType getSourceType() {
        return this.buttonGroup.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportType implements IHasName
    {
        PLAIN_TEXT(StoryUIMessages.WIZARD_PAGE_ImportText_ImportType_PlainText),
        STORY_FILE(StoryUIMessages.WIZARD_PAGE_ImportText_ImportType_StoryFile);

        private final String name;

        private ImportType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

