/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveRepresentationsChange;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.controllers.RepSelectionConsistentController;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.ChangeRepSelectionModel;
import edu.mit.story.ui.model.IChangeRepSelectionModel;
import edu.mit.story.ui.wizards.page.FactoryConfigPage;
import edu.mit.story.ui.wizards.page.RepConfigPage;
import edu.mit.story.ui.wizards.page.SpecifyChangeRepsPage;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ConfigureRepresentationsWizard
extends Wizard
implements IWorkbenchWizard {
    protected final IRepSelectionController<? extends IChangeRepSelectionModel> controller;
    protected final IStoryEditor editor;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SpecifyChangeRepsPage repPage;
    protected RepConfigPage repConfigPage;
    protected FactoryConfigPage factoryConfigPage;

    public ConfigureRepresentationsWizard(IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(StoryUIMessages.WIZARD_ConfigureRepresentations_title);
        this.setDefaultPageImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/corpus_wiz.gif"));
        ChangeRepSelectionModel model = new ChangeRepSelectionModel((Collection<? extends IRep>)editor.getSupported());
        IRepManager m = StoryPlugin.getDefault().getRepManager();
        for (IRep rep : m.getSupported()) {
            model.getSupported().add(rep);
        }
        for (IRep rep : model.getRequired()) {
            model.setRequired(rep, true);
        }
        RepSelectionConsistentController<ChangeRepSelectionModel> controller = new RepSelectionConsistentController<ChangeRepSelectionModel>(model);
        this.editor = editor;
        this.controller = controller;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(StoryUIMessages.WIZARD_ConfigureRepresentations_title);
        this.setDefaultPageImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/corpus_wiz.gif"));
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.repPage = new SpecifyChangeRepsPage(this.controller);
        this.addPage((IWizardPage)this.repPage);
        this.repConfigPage = new RepConfigPage();
        this.addPage((IWizardPage)this.repConfigPage);
        this.factoryConfigPage = new FactoryConfigPage();
        this.addPage((IWizardPage)this.factoryConfigPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next == this.repConfigPage) {
            this.repConfigPage.setRepresentations(this.controller.getModel().getNewlySelected());
        }
        if (next == this.factoryConfigPage) {
            this.factoryConfigPage.setRepresentations(this.controller.getModel().getNewlySelected());
        }
        return next;
    }

    public boolean performFinish() {
        Set<IRep> newChecked = this.controller.getModel().getNewlySelected();
        Set<IRep> unChecked = this.controller.getModel().getNewlyUnselected();
        if (!newChecked.isEmpty()) {
            AddRepsWithConfigChange addingRepsChange = new AddRepsWithConfigChange(newChecked, this.repConfigPage.getConfigurations().values(), this.factoryConfigPage.getConfiguration());
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)addingRepsChange, false);
        }
        if (!unChecked.isEmpty()) {
            RemoveRepresentationsChange removingRepsChange = new RemoveRepresentationsChange(unChecked);
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)removingRepsChange, false);
        }
        return true;
    }
}

