/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.descriptor.IRegisteredDescriptor;
import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.property.BooleanPropertyDescriptor;
import edu.mit.story.core.property.FilePropertyDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.core.validation.IDescriptorListValidator;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.dialogs.ExtensionFileFilter;
import edu.mit.story.ui.dialogs.WorkspaceFileSelectionDialog;
import edu.mit.story.ui.label.DescriptorLabelProvider;
import edu.mit.story.ui.validation.IConfigurationWidget;
import edu.mit.story.ui.widgets.ConfigurationWidget;
import edu.mit.story.ui.widgets.IPropertyEditor;
import edu.mit.story.ui.widgets.IPropertyWidget;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyWidget
extends ChangeNotifier
implements IPropertyWidget {
    String initialValue;
    IPropertyDescriptor desc;
    Composite control;
    IPropertyEditor editor;
    Label spacer;
    Label selLabel;
    IConfigurationWidget widget;

    public PropertyWidget(Composite parent, IPropertyDescriptor desc) {
        this(parent, desc.getDefaultValue(), desc);
    }

    public PropertyWidget(Composite parent, String initialValue, IPropertyDescriptor desc) {
        if (!desc.isValid(initialValue) && !desc.allowsInitialInvalidValue()) {
            IMessageProvider vm = desc.validate((Object)initialValue);
            throw new IllegalArgumentException(vm.getMessage());
        }
        this.initialValue = initialValue;
        this.desc = desc;
        this.createControl(parent);
    }

    public IPropertyDescriptor getPropertyDescriptor() {
        return this.desc;
    }

    public Control getControl() {
        return this.control;
    }

    public String getValue() {
        return this.editor == null ? this.initialValue : this.editor.getValue();
    }

    public IConfiguration getConfiguration() {
        return this.widget == null ? null : this.widget.getConfiguration();
    }

    public void setValue(String newValue) {
        if (!this.desc.isValid(newValue)) {
            return;
        }
        if (this.editor == null) {
            this.initialValue = newValue;
        } else {
            this.editor.setValue(newValue);
        }
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(this.control, 0);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        nameLabel.setText(this.desc.getName());
        if (this.desc.getValidator() instanceof IDescriptorListValidator) {
            IDescriptorListValidator v = (IDescriptorListValidator)this.desc.getValidator();
            this.editor = new ListPropertyEditor(this.control, v.getDescriptors());
        } else if (this.desc instanceof BooleanPropertyDescriptor) {
            this.editor = new BooleanPropertyEditor(this.control);
        } else if (this.desc instanceof FilePropertyDescriptor) {
            FilePropertyDescriptor pdesc = (FilePropertyDescriptor)this.desc;
            this.editor = new FilePropertyEditor(this.control, pdesc.getAllowedExtensions());
        } else {
            this.editor = new DefaultPropertyEditor(this.control);
        }
        this.editor.setValue(this.initialValue);
        new Label(this.control, 0);
        Label descLabel = new Label(this.control, 64);
        descLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        descLabel.setText(this.desc.getDescription());
        if (this.editor instanceof ListPropertyEditor) {
            ListPropertyEditor listEditor = (ListPropertyEditor)this.editor;
            new Label(this.control, 0);
            this.selLabel = new Label(this.control, 64);
            this.selLabel.setLayoutData((Object)new GridData(4, 128, true, false));
            listEditor.getComboViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PropertyWidget.this.updateWidgets();
                }
            });
            this.updateWidgets();
        }
        this.notifyChangeListeners();
    }

    protected void updateWidgets() {
        ListPropertyEditor listEditor = (ListPropertyEditor)this.editor;
        IDescriptor value = SelectionUtils.extractSingle(listEditor.getComboViewer().getSelection(), IDescriptor.class);
        this.selLabel.setText(value.getDescription());
        if (this.desc.isConfigurableProperty()) {
            if (this.spacer != null) {
                this.spacer.dispose();
            }
            this.spacer = null;
            if (this.widget != null) {
                this.widget.getControl().dispose();
            }
            this.widget = null;
            IRegisteredDescriptor configDesc = (IRegisteredDescriptor)StoryPlugin.getDefault().getConfigurationManager().getDescriptor(value.getID());
            if (configDesc != null) {
                this.spacer = new Label(this.control, 0);
                this.widget = new ConfigurationWidget(this.control, (IConfigDescriptor)configDesc.create());
            }
        }
        this.control.getShell().layout(true, true);
    }

    public String getMessage() {
        IMessageProvider msg = this.desc.validate((Object)this.editor.getValue());
        return msg == null ? null : msg.getMessage();
    }

    public int getMessageType() {
        IMessageProvider msg = this.desc.validate((Object)this.editor.getValue());
        return msg == null ? 0 : msg.getMessageType();
    }

    protected class BooleanPropertyEditor
    implements IPropertyEditor {
        private Button editor;

        public BooleanPropertyEditor(Composite parent) {
            this.editor = new Button(parent, 32);
            this.editor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyWidget.this.notifyChangeListeners();
                }
            });
        }

        public Control getControl() {
            return this.editor;
        }

        public String getValue() {
            return Boolean.toString(this.editor.getSelection());
        }

        public void setValue(String value) {
            this.editor.setSelection(Boolean.parseBoolean(value));
        }
    }

    protected class DefaultPropertyEditor
    implements IPropertyEditor {
        private Text editor;

        public DefaultPropertyEditor(Composite parent) {
            this.editor = new Text(parent, 2048);
            this.editor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.editor.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PropertyWidget.this.notifyChangeListeners();
                }
            });
        }

        public Control getControl() {
            return this.editor;
        }

        public String getValue() {
            return this.editor.getText();
        }

        public void setValue(String value) {
            this.editor.setText(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilePropertyEditor
    implements IPropertyEditor {
        private Composite panel;
        private Text editor;
        private Button browser;
        private Set<String> exts;

        public FilePropertyEditor(Composite parent, Set<String> exts) {
            this.exts = exts;
            this.panel = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.panel.setLayout((Layout)layout);
            this.panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.editor = new Text(this.panel, 2048);
            this.editor.setLayoutData((Object)new GridData(4, 4, true, false));
            this.editor.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PropertyWidget.this.notifyChangeListeners();
                }
            });
            this.browser = new Button(this.panel, 8);
            this.browser.setText("&Browse");
            this.browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFile file = FilePropertyEditor.this.chooseInternal();
                    if (file == null) {
                        return;
                    }
                    FilePropertyEditor.this.setValue(file.getFullPath().toOSString());
                }
            });
        }

        private IFile chooseInternal() {
            String initSelection = this.editor.getText();
            IResource initSel = null;
            if (initSelection.length() > 0) {
                initSel = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(initSelection));
            }
            WorkspaceFileSelectionDialog dialog = new WorkspaceFileSelectionDialog(this.editor.getShell());
            dialog.setAllowMultiple(false);
            dialog.addFilter(new ExtensionFileFilter(null, this.exts.toArray(new String[this.exts.size()])));
            dialog.setInitialSelection(initSel);
            if (dialog.open() != 0) {
                return null;
            }
            return (IFile)dialog.getFirstResult();
        }

        @Override
        public Control getControl() {
            return this.editor;
        }

        @Override
        public String getValue() {
            return this.editor.getText();
        }

        @Override
        public void setValue(String value) {
            this.editor.setText(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListPropertyEditor
    implements IPropertyEditor {
        private List<? extends IDescriptor> input;
        private ComboViewer viewer;

        public ListPropertyEditor(Composite parent, List<? extends IDescriptor> input) {
            this.input = input;
            this.viewer = new ComboViewer(parent, 8);
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new DescriptorLabelProvider());
            this.viewer.setInput(input);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PropertyWidget.this.notifyChangeListeners();
                }
            });
            this.viewer.getCombo().select(0);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        public ComboViewer getComboViewer() {
            return this.viewer;
        }

        @Override
        public Control getControl() {
            return this.viewer.getControl();
        }

        @Override
        public String getValue() {
            IDescriptor d = SelectionUtils.extractSingle(this.viewer.getSelection(), IDescriptor.class);
            return d.getID();
        }

        @Override
        public void setValue(String value) {
            for (IDescriptor iDescriptor : this.input) {
                if (!iDescriptor.getID().equals(value)) continue;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)iDescriptor));
                return;
            }
        }
    }
}

