/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.util.ICanSelect;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ButtonEnumGroup<T extends Enum<T>>
extends ChangeNotifier
implements INotifyingMessageProvider,
ICanSelect {
    protected Composite composite;
    protected Class<T> enumType;
    protected int numColumns;
    protected int HORIZONTAL_GAP = 8;
    protected Composite buttonGroup;
    protected Button[] buttons;
    protected boolean useGroup = false;
    protected String groupTitle = "";
    private ListenerList selectionListeners = new ListenerList();
    protected boolean outOfSync = true;
    protected IMessageProvider message = Message.NO_MESSAGE;

    public ButtonEnumGroup(Class<T> enumType) {
        this.enumType = enumType;
        this.numColumns = ((Enum[])enumType.getEnumConstants()).length;
    }

    public Class<T> getEnumType() {
        return this.enumType;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns < 1 ? ((Enum[])this.enumType.getEnumConstants()).length : numColumns;
    }

    public void setGroupTitle(String groupTitle) {
        this.groupTitle = groupTitle;
    }

    public void setUseGroup(boolean useGroup) {
        this.useGroup = useGroup;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void createComposite(Composite parent, int style) {
        if (this.composite != null) {
            throw new IllegalStateException();
        }
        this.composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        this.createButtonGroup(this.composite);
        this.createButtons(this.buttonGroup);
    }

    protected void createButtonGroup(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.HORIZONTAL_GAP;
        layout.numColumns = this.numColumns;
        if (this.useGroup) {
            this.buttonGroup = new Group(parent, 0);
            if (this.groupTitle != null) {
                ((Group)this.buttonGroup).setText(this.groupTitle);
            }
        } else {
            this.buttonGroup = new Composite(parent, 0);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.buttonGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.buttonGroup.setLayoutData((Object)gd);
    }

    protected abstract void createButtons(Composite var1);

    protected abstract void doValidate();

    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setEnabled(enabled);
            ++i;
        }
    }

    public String getMessage() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessage();
    }

    public int getMessageType() {
        if (this.outOfSync) {
            this.doValidate();
        }
        return this.message.getMessageType();
    }

    protected void notifySelectionListeners(SelectionEvent event) {
        Object[] objectArray = this.selectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SelectionListener)listener).widgetSelected(event);
            ++n2;
        }
    }

    protected void notifySelectionListenersDefault(SelectionEvent event) {
        Object[] objectArray = this.selectionListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((SelectionListener)listener).widgetSelected(event);
            ++n2;
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove((Object)listener);
    }
}

