/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.views;

import edu.mit.story.core.descriptor.DescriptorLabelFormatter;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IFormatter;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.RepActionUtils;
import edu.mit.story.ui.content.IHasTreeViewer;
import edu.mit.story.ui.content.RepContentProvider;
import edu.mit.story.ui.label.RepresentationLabelProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ResourceAction;

public class RepresentationTree
extends ViewPart
implements IHasRep,
IHasTreeViewer {
    IRep fInput;
    Text repName;
    TreeViewer fViewer;
    Composite fParent;
    DescriptorLabelFormatter fFormatter;
    RepresentationLabelProvider fLabelProvider;
    RepContentProvider fContentProvider;
    MenuManager fPopupManager;
    IAction fFocusOnRepresentationAction;
    IAction fSupertypesAction;
    IAction fSubtypesAction;
    IAction fShowRepIDAction;

    public void setRepresentation(IRep rep) {
        if (this.fInput == rep) {
            return;
        }
        this.fInput = rep;
        this.updateLabel();
        this.fViewer.refresh();
    }

    public IRep getRep() {
        return this.fInput;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.repName = new Text(parent, 0);
        this.repName.setBackground(parent.getBackground());
        this.repName.setEditable(false);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.repName.setLayoutData((Object)data);
        this.fViewer = new TreeViewer(parent, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fViewer.getTree().setLayoutData((Object)data);
        this.fFormatter = DescriptorLabelFormatter.NAME_PAREN_ID;
        this.fLabelProvider = new RepresentationLabelProvider((IFormatter<? super IRep>)this.fFormatter, true);
        this.fContentProvider = new RepContentProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setInput((Object)this);
        this.createActions();
        this.updateLabel();
    }

    protected void createActions() {
        this.fFocusOnRepresentationAction = new FocusOnRepresentationAction();
        this.fSubtypesAction = new ShowSubtypesAction();
        this.fSupertypesAction = new ShowSupertypesAction();
        this.fShowRepIDAction = new ShowRepresentationIDAction();
        this.fSubtypesAction.setChecked(this.fContentProvider.isProvidingSubtree());
        this.fSupertypesAction.setChecked(!this.fContentProvider.isProvidingSubtree());
        this.fShowRepIDAction.setChecked(this.fFormatter.isShowingIDs());
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add(this.fSubtypesAction);
        toolbar.add(this.fSupertypesAction);
        IMenuManager pulldown = this.getViewSite().getActionBars().getMenuManager();
        pulldown.add(this.fSubtypesAction);
        pulldown.add(this.fSupertypesAction);
        pulldown.add((IContributionItem)new Separator());
        pulldown.add(this.fShowRepIDAction);
        this.fPopupManager = new MenuManager();
        this.fPopupManager.add((IContributionItem)new GroupMarker("focus.ext"));
        this.fPopupManager.add(this.fFocusOnRepresentationAction);
        this.fPopupManager.add((IContributionItem)new Separator());
        this.fPopupManager.add((IContributionItem)new GroupMarker("additions"));
        Menu popup = this.fPopupManager.createContextMenu((Control)this.fParent);
        this.fViewer.getTree().setMenu(popup);
        String menuID = this.getClass().getCanonicalName();
        this.getSite().registerContextMenu(menuID, this.fPopupManager, (ISelectionProvider)this.fViewer);
    }

    protected void updateLabel() {
        if (this.repName != null) {
            this.repName.setText(this.fInput != null ? this.fLabelProvider.getText(this.fInput) : "");
        }
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    protected class FocusOnRepresentationAction
    extends ResourceAction {
        public FocusOnRepresentationAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_FocusOnRepresentation_prefix);
        }

        public void run() {
            RepActionUtils.focusOn(RepresentationTree.this.getSite().getShell(), RepresentationTree.this);
        }
    }

    protected class ShowRepresentationIDAction
    extends ResourceAction {
        public ShowRepresentationIDAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_ToggleShowID_prefix, 2);
        }

        public void run() {
            if (RepresentationTree.this.fLabelProvider == null) {
                return;
            }
            if (this.isChecked()) {
                RepresentationTree.this.fLabelProvider.setFormatter((IFormatter<? super IRep>)DescriptorLabelFormatter.NAME_PAREN_ID);
            } else {
                RepresentationTree.this.fLabelProvider.setFormatter((IFormatter<? super IRep>)DescriptorLabelFormatter.NAME_ONLY);
            }
            RepresentationTree.this.updateLabel();
        }
    }

    protected class ShowSubtypesAction
    extends ResourceAction {
        public ShowSubtypesAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_ShowSubtypes_prefix, 2);
        }

        public void run() {
            if (RepresentationTree.this.fContentProvider == null) {
                return;
            }
            RepresentationTree.this.fContentProvider.setProvidingSubtree(true);
            RepresentationTree.this.fViewer.refresh();
            RepresentationTree.this.fSupertypesAction.setChecked(false);
        }
    }

    protected class ShowSupertypesAction
    extends ResourceAction {
        public ShowSupertypesAction() {
            super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_ShowSupertypes_prefix, 2);
        }

        public void run() {
            if (RepresentationTree.this.fContentProvider == null) {
                return;
            }
            RepresentationTree.this.fContentProvider.setProvidingSubtree(false);
            RepresentationTree.this.fViewer.refresh();
            RepresentationTree.this.fSubtypesAction.setChecked(false);
        }
    }
}

