/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ToggleFieldEditor
extends FieldEditor {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private String wasSelected;
    private Button checkBox = null;
    protected String trueValue = IDialogConstants.YES_LABEL;
    protected String falseValue = IDialogConstants.NO_LABEL;

    public ToggleFieldEditor(String name, String labelText, int style, Composite parent) {
        this.init(name, labelText);
        this.style = style;
        this.createControl(parent);
    }

    public ToggleFieldEditor(String name, String labelText, String trueValue, String falseValue, int style, Composite parent) {
        this.init(name, labelText);
        this.style = style;
        this.createControl(parent);
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public ToggleFieldEditor(String name, String label, String trueValue, String falseValue, Composite parent) {
        this(name, label, trueValue, falseValue, 0, parent);
    }

    protected boolean asBoolean(String value) {
        return value.equals(this.trueValue);
    }

    protected String asString(boolean value) {
        if (value) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumns;
                text = null;
            }
        }
        this.checkBox = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
        }
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.checkBox.setSelection(this.asBoolean(value));
            this.wasSelected = value;
        }
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.checkBox.setSelection(this.asBoolean(value));
            this.wasSelected = value;
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.asString(this.checkBox.getSelection()));
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String isSelected = ToggleFieldEditor.this.asString(ToggleFieldEditor.this.checkBox.getSelection());
                    ToggleFieldEditor.this.valueChanged(ToggleFieldEditor.this.wasSelected, isSelected);
                    ToggleFieldEditor.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ToggleFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(String oldValue, String newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireValueChanged("field_editor_value", oldValue, newValue);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (this.style == 1) {
            super.setEnabled(enabled, parent);
        }
        this.getChangeControl(parent).setEnabled(enabled);
    }
}

