/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.ui.preferences.editor.ComboFieldEditorWithButtons;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboListFieldEditor3
extends ComboFieldEditorWithButtons {
    String fAltPrefName;
    IValueMapper<String> fMapper;

    public ComboListFieldEditor3(String prefName, String labelText, String prefRemainderName, IValueMapper<String> mapper, Composite parent) {
        super(prefName, labelText, new TreeMap<String, String>(), parent);
        if (mapper == null || prefRemainderName == null) {
            throw new NullPointerException();
        }
        this.fAltPrefName = prefRemainderName;
        this.fMapper = mapper;
    }

    protected String getAlternatesPreferenceName() {
        return this.fAltPrefName;
    }

    @Override
    protected void doLoad() {
        String preferred = this.getPreferenceStore().getString(this.getPreferenceName());
        String alternates = this.getPreferenceStore().getString(this.fAltPrefName);
        Map<String, String> result = this.getNameToValueMap();
        result.clear();
        if (!"".equals(preferred)) {
            result.put(preferred, preferred);
        }
        for (String hostname : this.fMapper.reconstitute(alternates)) {
            result.put(hostname, hostname);
        }
        this.refreshCombo();
        super.doLoad();
    }

    @Override
    protected void doLoadDefault() {
        String preferred = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        String alternates = this.getPreferenceStore().getDefaultString(this.fAltPrefName);
        Map<String, String> result = this.getNameToValueMap();
        result.clear();
        if (!"".equals(preferred)) {
            result.put(preferred, preferred);
        }
        for (String hostname : this.fMapper.reconstitute(alternates)) {
            result.put(hostname, hostname);
        }
        this.refreshCombo();
        super.doLoadDefault();
    }

    @Override
    protected void doStore() {
        super.doStore();
        TreeSet<String> values = new TreeSet<String>();
        for (String value : this.getNameToValueMap().values()) {
            values.add(value);
        }
        values.remove(this.fValue);
        String alternates = this.fMapper.serialize(values);
        this.getPreferenceStore().putValue(this.fAltPrefName, alternates);
    }
}

