/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.ui.preferences.editor.ComboFieldEditor;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboFieldEditorWithButtons
extends ComboFieldEditor {
    private Button fNewButton;
    private Button fRemoveButton;
    public static int idx = 1;

    public ComboFieldEditorWithButtons(String prefName, String labelText, Map<String, String> nameToValueMap, Composite parent) {
        super(prefName, labelText, nameToValueMap, parent);
    }

    @Override
    public int getNumberOfControls() {
        return 4;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Button control = this.getNewButton(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getRemoveButton(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    public Button getNewButton(Composite parent) {
        if (this.fNewButton == null) {
            this.fNewButton = new Button(parent, 0);
            this.fNewButton.setText("Ne&w...");
            this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboFieldEditorWithButtons.this.newButtonPressed();
                }
            });
        }
        return this.fNewButton;
    }

    public Button getRemoveButton(Composite parent) {
        if (this.fRemoveButton == null) {
            this.fRemoveButton = new Button(parent, 0);
            this.fRemoveButton.setText("&Remove");
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboFieldEditorWithButtons.this.removeButtonPressed();
                }
            });
        }
        return this.fRemoveButton;
    }

    protected void newButtonPressed() {
        String[] pair = this.createNewPair();
        if (pair == null) {
            return;
        }
        this.getNameToValueMap().put(pair[0], pair[1]);
        this.fRemoveButton.setEnabled(this.getNameToValueMap().size() > 0);
        this.fRemoveButton.setEnabled(this.getNameToValueMap().size() > 0);
        this.refreshCombo();
        this.setComboName(pair[0]);
    }

    protected void removeButtonPressed() {
        String value;
        if (this.getNameToValueMap().size() == 0) {
            return;
        }
        String name = this.getComboControl().getItem(this.getComboControl().getSelectionIndex());
        if (!this.canRemovePair(name, value = this.getNameToValueMap().get(name))) {
            return;
        }
        int idx = 0;
        while (idx < this.getComboControl().getItemCount()) {
            if (this.getComboControl().getItem(idx).equals(name)) break;
            ++idx;
        }
        if (idx == this.getNameToValueMap().size() - 1) {
            --idx;
        }
        this.getNameToValueMap().remove(name);
        this.fRemoveButton.setEnabled(this.getNameToValueMap().size() > 0);
        this.refreshCombo();
        String newName = null;
        if (this.getComboControl().getItemCount() > 0) {
            newName = this.getComboControl().getItem(idx);
        }
        this.setComboName(newName);
    }

    protected abstract String[] createNewPair();

    protected boolean canRemovePair(String name, String value) {
        return true;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        if ((control = this.getComboControl()) != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns - 2;
        }
    }
}

