/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.ui.widgets.CheckOnDoubleClickListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedListFieldEditor<T>
extends FieldEditor {
    CheckboxTableViewer fTableViewer;
    Object fInput;
    ILabelProvider fLabelProvider;
    IStructuredContentProvider fContentProvider;
    IValueMapper<T> fMapper;
    ICheckStateListener fListener = null;

    public CheckedListFieldEditor(String prefKeyName, String labelText, Object input, IStructuredContentProvider contentProvider, IValueMapper<T> mapper, Composite parent) {
        this(prefKeyName, labelText, input, contentProvider, (ILabelProvider)new LabelProvider(), mapper, parent);
    }

    public CheckedListFieldEditor(String prefKeyName, String labelText, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, IValueMapper<T> mapper, Composite parent) {
        this(prefKeyName, labelText, input, contentProvider, labelProvider, mapper, null, parent);
    }

    public CheckedListFieldEditor(String prefKeyName, String labelText, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, IValueMapper<T> mapper, ICheckStateListener listener, Composite parent) {
        if (contentProvider == null || mapper == null) {
            throw new NullPointerException();
        }
        this.fInput = input;
        this.fLabelProvider = labelProvider == null ? new LabelProvider() : labelProvider;
        this.fContentProvider = contentProvider;
        this.fMapper = mapper;
        this.fListener = listener;
        this.init(prefKeyName, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.fTableViewer == null) {
            return;
        }
        ((GridData)this.fTableViewer.getTable().getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        control.setLayoutData((Object)data);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTableViewer.getTable().addSelectionListener((SelectionListener)new CheckOnDoubleClickListener());
        if (this.fListener != null) {
            this.fTableViewer.addCheckStateListener(this.fListener);
        }
        data = new GridData();
        data.horizontalSpan = numColumns;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setInput(this.fInput);
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        List selected = this.fMapper.reconstitute(value);
        if (selected == null) {
            return;
        }
        this.fTableViewer.setCheckedElements(selected.toArray(new Object[selected.size()]));
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        List selected = this.fMapper.reconstitute(value);
        if (selected == null) {
            return;
        }
        this.fTableViewer.setCheckedElements(selected.toArray(new Object[selected.size()]));
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store == null) {
            return;
        }
        Object[] selected = this.fTableViewer.getCheckedElements();
        ArrayList<Object> selList = new ArrayList<Object>(selected.length);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object sel = objectArray[n2];
            selList.add(sel);
            ++n2;
        }
        String value = this.fMapper.serialize(selList);
        store.putValue(this.getPreferenceName(), value);
    }

    public int getNumberOfControls() {
        return 1;
    }
}

