/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;

public class RepresentationConsistencyListener
implements ICheckStateListener {
    IRepSupporter fSupporter;
    IRepSet fRequired;

    public RepresentationConsistencyListener() {
        this(null);
    }

    public RepresentationConsistencyListener(IRepSet required) {
        this(required, null);
    }

    public RepresentationConsistencyListener(IRepSet required, IRepSupporter supporter) {
        this.setRequired(required);
        this.setSupporter((IRepSupporter)(supporter != null ? supporter : StoryPlugin.getDefault().getRepManager()));
    }

    public void setRequired(IRepSet required) {
        this.fRequired = required != null ? new RepSet((Collection)required) : null;
    }

    public void setSupporter(IRepSupporter supporter) {
        if (supporter == null) {
            throw new NullPointerException();
        }
        this.fSupporter = supporter;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (!(event.getSource() instanceof CheckboxTableViewer)) {
            return;
        }
        if (!(event.getElement() instanceof IRep)) {
            return;
        }
        CheckboxTableViewer viewer = (CheckboxTableViewer)event.getSource();
        IRep rep = (IRep)event.getElement();
        if (event.getChecked()) {
            IRepSet reps = RepUtils.getAllAntecedents((IRep)rep);
            for (IRep ante : reps) {
                viewer.setChecked((Object)ante, true);
            }
        } else if (this.fRequired != null && this.fRequired.contains((Object)rep)) {
            viewer.setChecked((Object)rep, true);
        } else {
            IRepSet reps = RepUtils.getAllDependents((IRep)rep, (IRepSupporter)this.fSupporter);
            for (IRep dep : reps) {
                viewer.setChecked((Object)dep, false);
            }
        }
    }
}

