/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.agreement.AgreementCalculatorManager;
import edu.mit.story.core.agreement.AgreementResult;
import edu.mit.story.core.agreement.IAgreeCalcDescriptor;
import edu.mit.story.core.agreement.IAgreementCalculator;
import edu.mit.story.core.agreement.IAgreementCalculatorManager;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.core.align.AlignedStoryModel;
import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.align.DescMap;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.ImmutableRepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.character.AlignedText;
import edu.mit.story.core.rep.character.CharAligner;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.IAlignedText;
import edu.mit.story.core.rep.character.IOffset;
import edu.mit.story.core.rep.character.Offset;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.model.ICalculateAgreementModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateAgreementOperation
extends WorkspaceModifyOperation {
    private final String srcName;
    private final String tgtName;
    private final String fileName;
    private final IStoryModel srcModel;
    private final IStoryModel tgtModel;
    private final IRepSet reps;

    public CalculateAgreementOperation(String fileName, ICalculateAgreementModel model) {
        this(fileName, model.getSourceTag(), model.getTargetTag(), model.getSourceModel(), model.getTargetModel(), model.getIncluded());
    }

    public CalculateAgreementOperation(String fileName, String srcName, String tgtName, IStoryModel srcModel, IStoryModel tgtModel, Set<IRep> reps) {
        if (srcName == null) {
            throw new NullPointerException();
        }
        if (tgtName == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        if (srcModel == null) {
            throw new NullPointerException();
        }
        if (tgtModel == null) {
            throw new NullPointerException();
        }
        if (reps == null) {
            throw new NullPointerException();
        }
        srcName = srcName.trim();
        tgtName = tgtName.trim();
        if (srcName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (tgtName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (reps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.srcName = srcName;
        this.tgtName = tgtName;
        this.fileName = fileName;
        this.srcModel = srcModel;
        this.tgtModel = tgtModel;
        this.reps = new ImmutableRepSet(reps);
    }

    protected void execute(IProgressMonitor pm) {
        String prefix = String.valueOf(this.fileName) + "... ";
        pm.beginTask(prefix, this.reps.size() + 2);
        pm.subTask(String.valueOf(prefix) + "checking");
        this.checkModels();
        pm.worked(1);
        pm.subTask(String.valueOf(prefix) + "aligning");
        IAlignedStoryModel alignedModel = this.alignModels();
        pm.worked(1);
        LinkedList<IAgreementResult> results = new LinkedList<IAgreementResult>();
        for (IRep rep : this.reps) {
            pm.subTask(String.valueOf(prefix) + "calculating agreement..." + rep.getDescriptionName(IRep.Form.PLURAL_LOWER));
            results.add(this.calculateAgreement(alignedModel, rep));
            pm.worked(1);
        }
        this.reportResults(results);
        pm.done();
    }

    protected void reportResults(List<IAgreementResult> results) {
        for (IAgreementResult result : results) {
            System.out.println(result);
        }
    }

    protected void checkModels() {
        for (IRep rep : this.reps) {
            if (!this.srcModel.supports(rep)) {
                this.failWithMessage("Source model does not support the " + rep.getName() + " representation (" + rep.getID() + ")");
            }
            if (this.tgtModel.supports(rep)) continue;
            this.failWithMessage("Target model does not support the " + rep.getName() + " representation (" + rep.getID() + ")");
        }
    }

    protected void failWithMessage(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Alignment Problem", (String)message);
            }
        });
        throw new IllegalStateException();
    }

    protected IAlignedStoryModel alignModels() {
        IAlignedText alignment = this.alignText(this.srcModel.getData(), this.tgtModel.getData());
        this.checkAlignment(alignment);
        AlignedStoryModel alignedModel = new AlignedStoryModel(this.srcName, this.tgtName, this.srcModel, this.tgtModel, alignment);
        TreeMap<IRep, IMergeModel.Action> repActions = new TreeMap<IRep, IMergeModel.Action>();
        for (IRep rep : this.reps) {
            for (IRep ante : RepUtils.getAllAntecedents((IRep)rep)) {
                repActions.put(ante, IMergeModel.Action.ALIGN);
            }
        }
        for (IRep rep : this.reps) {
            repActions.put(rep, IMergeModel.Action.MERGE);
        }
        for (Map.Entry entry : repActions.entrySet()) {
            this.align((IRep)entry.getKey(), (IAlignedStoryModel)alignedModel, entry.getValue() == IMergeModel.Action.ALIGN);
        }
        return alignedModel;
    }

    protected IAlignedText alignText(IStoryData srcData, IStoryData tgtData) {
        StringBuilder srcStr = new StringBuilder(srcData.getLength());
        StringBuilder tgtStr = new StringBuilder(srcData.getLength());
        TextRep.getText((IHasPosition)srcData, (IStoryData)srcData, (StringBuilder)srcStr);
        TextRep.getText((IHasPosition)tgtData, (IStoryData)tgtData, (StringBuilder)tgtStr);
        int srcLen = srcStr.length();
        int tgtLen = tgtStr.length();
        ArrayList<Offset> srcOffs = new ArrayList<Offset>(srcLen);
        ArrayList<Offset> tgtOffs = new ArrayList<Offset>(tgtLen);
        int i = 0;
        while (i < srcLen) {
            srcOffs.add(new Offset(srcStr.charAt(i), i));
            ++i;
        }
        i = 0;
        while (i < tgtLen) {
            tgtOffs.add(new Offset(tgtStr.charAt(i), i));
            ++i;
        }
        try {
            List alignment = CharAligner.getInstance().align(srcOffs, tgtOffs);
            return new AlignedText((ITextStore)CharRep.extractCharStore((Collection)srcData), (ITextStore)CharRep.extractCharStore((Collection)tgtData), alignment);
        }
        catch (OutOfMemoryError e) {
            this.failWithMessage(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    protected void checkAlignment(IAlignedText alignment) {
        IOffset lastSrc = null;
        Aligner.Pair problem = null;
        for (Aligner.Pair pair : alignment) {
            if (pair.a != null) {
                lastSrc = (IOffset)pair.a;
            }
            if (pair.a == null && !Character.isWhitespace(((IOffset)pair.b).getChar())) {
                problem = pair;
                break;
            }
            if (pair.b != null || Character.isWhitespace(((IOffset)pair.a).getChar())) continue;
            problem = pair;
            break;
        }
        if (problem != null) {
            int tgtOffset = problem.b == null ? alignment.getOffset(lastSrc.getOffset()) : ((IOffset)problem.b).getOffset();
            StringBuilder sb = new StringBuilder();
            sb.append("The texts differ at source offset ");
            sb.append(lastSrc == null ? lastSrc : Integer.toString(lastSrc.getOffset()));
            sb.append(" and target offset ");
            sb.append(Integer.toString(tgtOffset));
            sb.append('\n');
            sb.append(this.srcName);
            sb.append(": ...");
            sb.append(lastSrc == null ? lastSrc : this.getSurroundingText(lastSrc.getOffset(), alignment.getSource()));
            sb.append("...\n");
            sb.append(this.tgtName);
            sb.append(": ...");
            sb.append(this.getSurroundingText(tgtOffset, alignment.getTarget()));
            sb.append("...");
            this.failWithMessage(sb.toString());
        }
    }

    private String getSurroundingText(int offset, ITextStore store) {
        int off = Math.max(offset - 20, 0);
        int roff = Math.min(offset + 20, store.getLength());
        return store.get(off, roff - off).replaceAll("\\s+", " ");
    }

    protected void align(IRep rep, IAlignedStoryModel alignedModel, boolean enforceInjective) {
        IDescSet srcDescs = this.srcModel.getData().getDescriptions(rep);
        IDescSet tgtDescs = this.tgtModel.getData().getDescriptions(rep);
        IDescMap align = null;
        if (rep.isTransferable()) {
            align = this.alignExactly(srcDescs, tgtDescs, alignedModel);
            if (enforceInjective && !DescMap.isInjective((IDescMap)align)) {
                srcDescs = new DescSet(srcDescs);
                tgtDescs = new DescSet(tgtDescs);
                Iterator i = srcDescs.iterator();
                while (i.hasNext()) {
                    if (!tgtDescs.remove((Object)align.getDescription(((IDesc)i.next()).getID()))) continue;
                    i.remove();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to find 1-to-1 mapping for ");
                sb.append(rep.getDescriptionName(IRep.Form.PLURAL_UPPER));
                sb.append(" (");
                sb.append(rep.getID());
                sb.append(")\n\n");
                sb.append(this.srcName);
                sb.append(":\n");
                for (IDesc d : srcDescs) {
                    sb.append(d.toString());
                    sb.append('\n');
                }
                sb.append('\n');
                sb.append(this.tgtName);
                sb.append(":\n");
                for (IDesc d : tgtDescs) {
                    sb.append(d.toString());
                    sb.append('\n');
                }
                this.failWithMessage(sb.toString());
            }
        } else {
            align = new DescMap(srcDescs, tgtDescs, null);
        }
        alignedModel.put(align, null);
    }

    protected IDescMap alignExactly(IDescSet srcDescs, IDescSet tgtDescs, IAlignedStoryModel alignedModel) {
        DescSet tgtRemove = new DescSet(tgtDescs);
        LinkedList<Aligner.Pair> alignment = new LinkedList<Aligner.Pair>();
        IAlignedText alignedText = alignedModel.getAlignedText();
        block0: for (IDesc srcDesc : srcDescs) {
            int srcROffsetInTgt;
            int srcLengthInTgt;
            int srcOffsetInTgt = alignedText.getOffset(srcDesc.getOffset());
            SimplePosition p = new SimplePosition(srcOffsetInTgt, srcLengthInTgt = (srcROffsetInTgt = alignedText.getRightOffset(srcDesc.getRightOffset())) - srcOffsetInTgt);
            IDescSet matches = tgtRemove.matchSet((IHasPosition)p);
            if (matches.isEmpty()) continue;
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                IDesc tgtDesc = (IDesc)i.next();
                if (!Desc.equals((IDesc)srcDesc, (IDesc)tgtDesc, (IAlignedStoryModel)alignedModel)) continue;
                alignment.add(new Aligner.Pair((Object)srcDesc, (Object)tgtDesc));
                i.remove();
                continue block0;
            }
        }
        return new DescMap(srcDescs, tgtDescs, alignment);
    }

    protected IAgreementResult calculateAgreement(IAlignedStoryModel model, IRep rep) {
        IAgreementCalculatorManager manager = AgreementCalculatorManager.getInstance();
        List descs = manager.getDescriptors(rep);
        LinkedList<IAgreementResult> results = new LinkedList<IAgreementResult>();
        for (IAgreeCalcDescriptor desc : descs) {
            List<IAgreementResult> rs;
            try {
                rs = this.calculateAgreement(model, desc, rep);
            }
            catch (Throwable throwable) {
                continue;
            }
            results.addAll(rs);
        }
        return new AgreementResult(rep.getName(), "", rep, results);
    }

    protected List<IAgreementResult> calculateAgreement(IAlignedStoryModel model, IAgreeCalcDescriptor desc, IRep rep) {
        IAgreementCalculator calc = (IAgreementCalculator)desc.create();
        return calc.calculate(model, Collections.singleton(rep));
    }
}

