/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.model;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import edu.mit.story.core.datamodel.BatchPairModel;
import edu.mit.story.core.datamodel.StoryPairModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.model.ICalculateAgreementBatchModel;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateAgreementBatchModel
extends BatchPairModel
implements ICalculateAgreementBatchModel {
    private final IRepSelectionModel repSelectionModel = new RepSelectionModel();

    public CalculateAgreementBatchModel() {
        this.repSelectionModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CalculateAgreementBatchModel.this.fireChanged();
            }
        });
    }

    protected void fileSetChanged() {
        try {
            this.suppressNotifications();
            StoryPairModel pairModel = new StoryPairModel();
            Table.Cell<IFile, IFile, Boolean> first = this.getFirst();
            if (first != null) {
                IFile srcFile = (IFile)first.getRowKey();
                IFile tgtFile = (IFile)first.getColumnKey();
                pairModel.setSource(srcFile == null ? null : srcFile.getRawLocation().toFile());
                pairModel.setTarget(tgtFile == null ? null : tgtFile.getRawLocation().toFile());
            } else {
                pairModel.clear();
            }
            IStoryModel source = pairModel.getSourceModel();
            IStoryModel target = pairModel.getTargetModel();
            if (source == null || target == null) {
                if (!this.repSelectionModel.getSupported().isEmpty()) {
                    try {
                        this.repSelectionModel.suppressNotifications();
                        this.repSelectionModel.getSupported().clear();
                    }
                    finally {
                        this.repSelectionModel.allowNotifications();
                    }
                }
                return;
            }
            Sets.SetView both = Sets.intersection((Set)source.getSupported(), (Set)target.getSupported());
            this.repSelectionModel.getSupported().retainAll((Collection<?>)both);
            this.repSelectionModel.getSupported().addAll((Collection<IRep>)both);
        }
        finally {
            this.allowNotifications();
        }
    }

    protected Table.Cell<IFile, IFile, Boolean> getFirst() {
        for (Table.Cell cell : this.getResourcePairs().cellSet()) {
            if (!((Boolean)cell.getValue()).booleanValue()) continue;
            return cell;
        }
        return null;
    }

    @Override
    public Set<IRep> getIncluded() {
        return this.repSelectionModel.getIncluded();
    }

    @Override
    public Set<IRep> getRequired() {
        return this.repSelectionModel.getRequired();
    }

    @Override
    public Set<IRep> getSelected() {
        return this.repSelectionModel.getSelected();
    }

    @Override
    public SortedSet<IRep> getSupported() {
        return this.repSelectionModel.getSupported();
    }

    @Override
    public boolean isIncluded(IRep rep) {
        return this.repSelectionModel.isIncluded(rep);
    }

    @Override
    public boolean isRequired(IRep rep) {
        return this.repSelectionModel.isRequired(rep);
    }

    @Override
    public boolean isSelected(IRep rep) {
        return this.repSelectionModel.isSelected(rep);
    }

    @Override
    public boolean isSupported(IRep rep) {
        return this.repSelectionModel.isSupported(rep);
    }

    @Override
    public void setRequired(IRep rep, boolean isRequired) {
        this.repSelectionModel.setRequired(rep, isRequired);
    }

    @Override
    public void setSelected(IRep rep, boolean isSelected) {
        this.repSelectionModel.setSelected(rep, isSelected);
    }
}

