/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.label.RepresentationLabelProvider;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class TransferLabelProvider
extends RepresentationLabelProvider {
    private final IMergeModel.Action fixedOrigin;
    private Image sourceImg;
    private Image targetImg;
    private Image mergeImg;
    private Image alignImg;
    private Image neitherImg;

    public TransferLabelProvider() {
        this(null);
    }

    public TransferLabelProvider(IMergeModel.Action o) {
        this.fixedOrigin = o;
    }

    public String getText(Object element) {
        if (element instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)element;
            element = e.getKey();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IRep) {
            element = this.fixedOrigin;
        }
        if (element instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)element;
            element = e.getValue();
        }
        if (element instanceof IMergeModel.Action) {
            IMergeModel.Action o = (IMergeModel.Action)element;
            switch (o) {
                case TRANSFER_FROM_SOURCE: {
                    return this.getSourceImg();
                }
                case TRANSFER_FROM_TARGET: {
                    return this.getTargetImg();
                }
                case ALIGN: {
                    return this.getAlignImg();
                }
                case MERGE: {
                    return this.getMergeImg();
                }
                case IGNORE: {
                    return this.getNeitherImg();
                }
            }
        }
        return super.getImage(element);
    }

    protected Image getMergeImg() {
        if (this.mergeImg == null) {
            this.mergeImg = StoryUIPlugin.getDefault().getImageRegistry().get("ctool16/merge.gif");
        }
        return this.mergeImg;
    }

    protected Image getAlignImg() {
        if (this.alignImg == null) {
            this.alignImg = StoryUIPlugin.getDefault().getImageRegistry().get("etool16/sync.gif");
        }
        return this.alignImg;
    }

    protected Image getTargetImg() {
        if (this.targetImg == null) {
            this.targetImg = StoryUIPlugin.getDefault().getImageRegistry().get("ctool16/tranfer_from_target.gif");
        }
        return this.targetImg;
    }

    protected Image getSourceImg() {
        if (this.sourceImg == null) {
            this.sourceImg = StoryUIPlugin.getDefault().getImageRegistry().get("ctool16/transfer_from_source.gif");
        }
        return this.sourceImg;
    }

    protected Image getNeitherImg() {
        if (this.neitherImg == null) {
            this.neitherImg = StoryUIPlugin.getDefault().getImageRegistry().get("ctool16/neither.gif");
        }
        return this.neitherImg;
    }
}

