/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IHasMetaRep;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.mark.MarkMetaRep;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.meta.note.INote;
import edu.mit.story.core.meta.note.NoteMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.util.IHasDisplayText;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public abstract class StoryModelLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IFontProvider,
IColorProvider {
    private final Pattern linebreakPattern = Pattern.compile("\n|\r|\r\n");
    private final IStoryEditor editor;
    private final IHasStoryEditor editorProvider;
    private Image modelImg;
    private Image noneImg;
    private Image noteImg;
    private ImageDescriptor markImg;
    private static final Color COLOR_RED = StoryUIPlugin.getDefault().getColorManager().get("RED");
    public static final StyledString.Styler TAG_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = COLOR_RED;
        }
    };

    public StoryModelLabelProvider(IStoryEditor editor) {
        this.editor = editor;
        this.editorProvider = null;
    }

    public StoryModelLabelProvider(IHasStoryEditor editorProvider) {
        if (editorProvider == null) {
            throw new NullPointerException();
        }
        this.editorProvider = editorProvider;
        this.editor = null;
    }

    public IStoryEditor getStoryEditor() {
        if (this.editorProvider != null) {
            return this.editorProvider.getStoryEditor();
        }
        return this.editor;
    }

    public void update(ViewerCell cell) {
        Object[] newStyleRanges;
        Object element = cell.getElement();
        StyledString styledString = this.getStyledText(element);
        String newText = styledString.toString();
        Object[] oldStyleRanges = cell.getStyleRanges();
        Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
        if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
            cell.setStyleRanges((StyleRange[])newStyleRanges);
            if (cell.getText().equals(newText)) {
                cell.setText("");
            }
        }
        Image img = this.getImage(element);
        img = this.decorate(img, element);
        cell.setText(newText);
        cell.setImage(img);
        cell.setFont(this.getFont(element));
        cell.setForeground(this.getForeground(element));
        cell.setBackground(this.getBackground(element));
    }

    protected Image decorate(Image img, Object element) {
        if (element instanceof IDesc && MarkMetaRep.isMarked((IDesc)((IDesc)element))) {
            ImageDescriptor markImg = this.getMarkImage();
            DecorationOverlayIcon icon = new DecorationOverlayIcon(img, markImg, 0);
            return icon.createImage();
        }
        return img;
    }

    public final String getText(Object element) {
        StyledString str = this.getStyledText(element);
        if (str == null) {
            return "";
        }
        return str.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof IStoryModel) {
            return this.getStoryModelImage();
        }
        if (element instanceof INoElementsMessage) {
            return this.getNoElementsImage();
        }
        if (element instanceof IMetaDesc) {
            IMetaDesc md = (IMetaDesc)element;
            if (NoteMetaRep.getInstance().isType((IHasMetaRep)md)) {
                return this.getNoteImage();
            }
        }
        if (element instanceof IMetaDataSet) {
            return this.getNoteImage();
        }
        if (element instanceof StoryEditorContentProvider.Element) {
            StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
            return this.getImage(child.getType(), child.getParent(), child.getElement());
        }
        return null;
    }

    protected Image getImage(int type, Object parent, Object element) {
        return this.getImage(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element == null) {
            return new StyledString("(null object)");
        }
        if (element instanceof IStoryModel) {
            return new StyledString(this.getStoryEditor().getEditorInput().getName());
        }
        if (element instanceof INoElementsMessage) {
            INoElementsMessage message = (INoElementsMessage)element;
            return new StyledString(message.getDisplayText());
        }
        if (element instanceof IMetaDesc) {
            IMetaDesc md = (IMetaDesc)element;
            if (NoteMetaRep.getInstance().isType((IHasMetaRep)md)) {
                INote note = (INote)md.getData();
                Matcher m = this.linebreakPattern.matcher(note.getNote());
                return new StyledString(m.replaceAll(" "));
            }
        }
        if (element instanceof IMetaDataSet) {
            IMetaDataSet descs = (IMetaDataSet)element;
            return new StyledString(descs.getMetaRep().getName(), StyledString.COUNTER_STYLER);
        }
        if (element instanceof StoryEditorContentProvider.Element) {
            StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
            return this.getStyledText(child.getType(), child.getParent(), child.getElement());
        }
        return new StyledString(element.toString());
    }

    protected StyledString getStyledText(int type, Object parent, Object element) {
        return this.getStyledText(element);
    }

    protected Image getStoryModelImage() {
        if (this.modelImg == null) {
            this.modelImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/story.gif");
        }
        return this.modelImg;
    }

    protected Image getNoElementsImage() {
        if (this.noneImg == null) {
            this.noneImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/smallx.gif");
        }
        return this.noneImg;
    }

    protected Image getNoteImage() {
        if (this.noteImg == null) {
            this.noteImg = StoryUIPlugin.getDefault().getImageRegistry().get("obj16/note.gif");
        }
        return this.noteImg;
    }

    protected ImageDescriptor getMarkImage() {
        if (this.markImg == null) {
            this.markImg = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("ovr16/mark_ovr.gif");
        }
        return this.markImg;
    }

    public static StyledString appendID(StyledString result, long id) {
        if (id >= 0L) {
            result.append(" (", StyledString.DECORATIONS_STYLER);
            result.append(Long.toString(id), StyledString.DECORATIONS_STYLER);
            result.append(')', StyledString.DECORATIONS_STYLER);
        }
        return result;
    }

    public static StyledString appendMergeTags(StyledString result, IDesc desc) {
        SortedSet profile = MergeMetaRep.extractMergeProfile((IDesc)desc);
        Iterator i = profile.iterator();
        if (i.hasNext()) {
            result.append(' ');
        }
        while (i.hasNext()) {
            result.append((String)i.next(), TAG_STYLER);
            if (!i.hasNext()) continue;
            result.append(", ", TAG_STYLER);
        }
        return result;
    }

    public static interface INoElementsMessage
    extends IHasDisplayText {
    }

    public static class NoElementsMessage
    implements INoElementsMessage {
        private final String message;

        public NoElementsMessage(String message) {
            if (message.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.message = message;
        }

        public String getDisplayText() {
            return this.message;
        }
    }
}

