/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DecoratedImageDescriptor
extends CompositeImageDescriptor {
    private final Image base;
    private final Image overlay;
    private final int vPos;
    private final int hPos;

    public DecoratedImageDescriptor(Image base, Image overlay) {
        this(base, overlay, 132096);
    }

    public DecoratedImageDescriptor(Image base, Image overlay, int posBits) {
        if (base == null || overlay == null) {
            throw new NullPointerException();
        }
        this.base = base;
        this.overlay = overlay;
        this.vPos = this.checkVertical(posBits);
        this.hPos = this.checkHorizontal(posBits);
    }

    protected int checkVertical(int pos) {
        if ((pos & 0x400) != 0) {
            return 1024;
        }
        if ((pos & 0x80) != 0) {
            return 128;
        }
        return 1024;
    }

    protected int checkHorizontal(int pos) {
        if ((pos & 0x20000) != 0) {
            return 131072;
        }
        if ((pos & 0x4000) != 0) {
            return 16384;
        }
        return 131072;
    }

    protected void drawCompositeImage(int width, int height) {
        Rectangle bb = this.base.getBounds();
        Rectangle ob = this.overlay.getBounds();
        int ox = this.hPos == 16384 ? 0 : bb.width - ob.width;
        int oy = this.vPos == 128 ? 0 : bb.height - ob.height;
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawImage(this.overlay.getImageData(), ox, oy);
    }

    protected Point getSize() {
        Rectangle r = this.base.getBounds();
        return new Point(r.width, r.height);
    }
}

