/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.label;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CompositeLabelProvider
extends LabelProvider {
    ILabelProvider[] fProviders;

    public CompositeLabelProvider(ILabelProvider ... providers) {
        if (providers.length == 0) {
            throw new IllegalArgumentException();
        }
        this.fProviders = new ILabelProvider[providers.length];
        System.arraycopy(providers, 0, this.fProviders, 0, providers.length);
    }

    public Image getImage(Object element) {
        Image result = null;
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            result = provider.getImage(element);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String result = null;
        String toString = super.getText(element);
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            result = provider.getText(element);
            if (!toString.equals(result)) {
                return result;
            }
            ++n2;
        }
        return toString;
    }

    public void addListener(ILabelProviderListener listener) {
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            provider.addListener(listener);
            ++n2;
        }
    }

    public void dispose() {
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            provider.dispose();
            ++n2;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            if (provider.isLabelProperty(element, property)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        ILabelProvider[] iLabelProviderArray = this.fProviders;
        int n = this.fProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProvider provider = iLabelProviderArray[n2];
            provider.removeListener(listener);
            ++n2;
        }
    }
}

