/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.editor;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.util.IEnableable;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoryEditorHighlighter<E extends IStoryEditor>
implements IEnableable {
    private E editor;
    private final String annoType;
    private final String annoMsg;
    private boolean isEnabled = false;

    public StoryEditorHighlighter(E targetEditor, String annoType, String annoMsg) {
        if (targetEditor == null) {
            throw new NullPointerException();
        }
        this.editor = targetEditor;
        if (annoType.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (annoMsg == null) {
            throw new NullPointerException();
        }
        this.annoType = annoType;
        this.annoMsg = annoMsg;
    }

    public void dispose() {
        this.editor = null;
    }

    protected abstract IHasPositionSet<? extends IHasPosition> getAnnotationPositions();

    public E getEditor() {
        return this.editor;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean setEnabled(final boolean value) {
        if (this.isEnabled == value) {
            return false;
        }
        this.isEnabled = value;
        WorkbenchUtils.runInUIThread(new Runnable(){

            public void run() {
                if (value) {
                    StoryEditorHighlighter.this.enableHighlighting();
                } else {
                    StoryEditorHighlighter.this.disableHighlighting();
                }
            }
        });
        return true;
    }

    protected void enableHighlighting() {
        IHasPositionSet<IHasPosition> hps = this.getAnnotationPositions();
        if (hps == null) {
            return;
        }
        HashMap<Annotation, Position> annoMap = new HashMap<Annotation, Position>(hps.size());
        for (IHasPosition hp : hps) {
            Position p = PositionUtils.toDocumentPosition((IHasPosition)hp);
            Annotation a = new Annotation(this.annoType, false, this.annoMsg);
            annoMap.put(a, p);
        }
        IAnnotationModel model = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        if (model instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)model).replaceAnnotations(null, annoMap);
        } else {
            for (Map.Entry entry : annoMap.entrySet()) {
                model.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    protected void refreshHighlighting() {
        if (this.isEnabled) {
            WorkbenchUtils.runInUIThread(new Runnable(){

                public void run() {
                    StoryEditorHighlighter.this.refreshHighlightingInternal();
                }
            });
        }
    }

    protected void refreshHighlightingInternal() {
        Annotation a;
        ArrayList<Position> ps;
        IHasPositionSet<IHasPosition> hps = this.getAnnotationPositions();
        ArrayList<Object> arrayList = ps = hps == null ? new ArrayList<Position>(0) : new ArrayList(hps.size());
        if (hps != null) {
            for (IHasPosition hp : hps) {
                ps.add(PositionUtils.toDocumentPosition((IHasPosition)hp));
            }
        }
        IAnnotationModel model = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        HashMap<Position, Annotation> currMap = new HashMap<Position, Annotation>();
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            a = (Annotation)i.next();
            if (!a.getType().equals(this.annoType)) continue;
            Position ap = model.getPosition(a);
            currMap.put(ap, a);
        }
        i = ps.iterator();
        while (i.hasNext()) {
            a = (Annotation)currMap.remove(i.next());
            if (a == null) continue;
            i.remove();
        }
        HashMap<Annotation, Position> annoMap = new HashMap<Annotation, Position>(ps.size());
        for (Position p : ps) {
            a = new Annotation(this.annoType, false, this.annoMsg);
            annoMap.put(a, p);
        }
        Annotation[] remove = currMap.values().toArray(new Annotation[currMap.values().size()]);
        if (model instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)model).replaceAnnotations(remove, annoMap);
        } else {
            Annotation[] annotationArray = remove;
            int n = remove.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation an = annotationArray[n2];
                model.removeAnnotation(an);
                ++n2;
            }
            for (Map.Entry entry : annoMap.entrySet()) {
                model.removeAnnotation((Annotation)entry.getKey());
                model.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
    }

    protected void disableHighlighting() {
        IAnnotationModel model = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
        ArrayList<Annotation> annoList = new ArrayList<Annotation>();
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.getType().equals(this.annoType)) continue;
            annoList.add(a);
        }
        if (model instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)model).replaceAnnotations(annoList.toArray(new Annotation[annoList.size()]), null);
        } else {
            for (Annotation an : annoList) {
                model.removeAnnotation(an);
            }
        }
    }
}

