/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.document;

import edu.mit.story.core.property.CorpusConfigExporter;
import edu.mit.story.core.property.ICorpusConfiguration;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.ops.CreateCorpusOperation;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.w3c.dom.Document;

public class CreateConfiguredCorpusRunnable
implements IRunnableWithProgress {
    private final IPath path;
    private final IProject project;
    private final ICorpusConfiguration projectConfig;

    public CreateConfiguredCorpusRunnable(IPath path, IProject project, ICorpusConfiguration projectConfig) {
        if (project == null) {
            throw new NullPointerException();
        }
        if (projectConfig.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.project = project;
        this.projectConfig = projectConfig;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Object writeOp;
        ISchedulingRule writeRule;
        monitor.beginTask("", 5000);
        CreateCorpusOperation op = new CreateCorpusOperation(this.path, this.project);
        op.run((IProgressMonitor)new SubProgressMonitor(monitor, 4000));
        Document xml = CorpusConfigExporter.getInstance().exportToXML(this.projectConfig);
        final InputStream is = XMLUtils.toStream((Document)xml);
        final IFile file = op.getProject().getFile(".corpus");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (file.exists()) {
            writeRule = workspace.getRuleFactory().modifyRule((IResource)file);
            writeOp = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    file.setContents(is, true, true, monitor);
                }
            };
        } else {
            writeRule = workspace.getRuleFactory().createRule((IResource)file);
            writeOp = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    file.create(is, true, monitor);
                }
            };
        }
        try {
            workspace.run(writeOp, writeRule, 1, null);
        }
        catch (CoreException e) {
            Status status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

