/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.dialogs.RepChooserDialog;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DescEditingDialog
extends StatusDialog {
    Annotation fPosAnnotation = new Annotation("edu.mit.story.ui.annotation.target0", false, StoryUIMessages.ANNOTATION_DescriptionEditing_text);
    IAnnotationModelExtension fModel = null;
    final IStoryEditor fEditor;
    final IDesc fDesc;
    IData fData;
    IRep fRep;
    int fOffset;
    int fLength;
    Spinner offsetInput;
    Spinner lengthInput;
    Text repInput;
    Text dataInput;
    int BAD_POSITION = 1;
    int BAD_REP = 2;
    int BAD_DATA = 3;
    String oldValue;

    public DescEditingDialog(IDesc desc, IStoryEditor editor, Shell parent) {
        super(parent);
        this.setTitle(StoryUIMessages.DIALOG_EditDescription_title);
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fModel = (IAnnotationModelExtension)this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        }
        this.fDesc = desc;
        this.fRep = desc.getRep();
        this.fData = desc.getData();
        this.fOffset = desc.getOffset();
        this.fLength = desc.getLength();
        this.setStatusLineAboveButtons(false);
    }

    public DescEditingDialog(IHasPosition range, IRep rep, IData data, IStoryEditor editor, Shell parent) {
        super(parent);
        this.setTitle(StoryUIMessages.DIALOG_CreateDescription_title);
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fModel = (IAnnotationModelExtension)this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        }
        this.fDesc = null;
        this.fRep = rep;
        this.fData = data;
        this.fOffset = range == null ? 0 : range.getOffset();
        this.fLength = range == null ? 0 : range.getLength();
        this.setStatusLineAboveButtons(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        final Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        inner.setLayout((Layout)layout);
        Label dataLabel = new Label(inner, 0);
        dataLabel.setText("Data:");
        this.dataInput = new Text(inner, 2052);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.dataInput.setLayoutData((Object)data);
        if (this.fRep == null) {
            this.dataInput.setEnabled(false);
        } else if (this.fRep.getDataFormat() != null) {
            this.dataInput.setEnabled(true);
            this.dataInput.setText(this.fRep.serialize(this.fData));
        } else {
            this.dataInput.setEnabled(false);
        }
        this.dataInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DescEditingDialog.this.validate();
            }
        });
        Label blank = new Label(inner, 0);
        Label repLabel = new Label(inner, 0);
        repLabel.setText("Representation:");
        this.repInput = new Text(inner, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.repInput.setLayoutData((Object)data);
        if (this.fDesc != null) {
            this.repInput.setText(this.fDesc.getRep().getID());
        } else {
            this.repInput.setText(this.fRep != null ? this.fRep.getID() : "");
        }
        this.repInput.setEnabled(this.fDesc == null);
        Button button = new Button(inner, 0);
        button.setText("Brows&e...");
        button.setEnabled(this.fDesc == null | this.fRep != null);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RepChooserDialog dialog = new RepChooserDialog(DescEditingDialog.this.fEditor.getStoryModel().getPrimary(), inner.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                IRep newRep = dialog.getSelectedRepresentation();
                if (newRep != null) {
                    DescEditingDialog.this.fRep = newRep;
                    DescEditingDialog.this.repInput.setText(DescEditingDialog.this.fRep.getID());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.repInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DescEditingDialog.this.validate();
            }
        });
        Composite labels = new Composite(inner, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 2 * layout.verticalSpacing;
        layout.numColumns = 1;
        labels.setLayout((Layout)layout);
        Label offsetLabel = new Label(labels, 0);
        offsetLabel.setText("Offset:");
        Label lengthLabel = new Label(labels, 131072);
        lengthLabel.setText("Length:");
        Composite input = new Composite(inner, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = true;
        input.setLayout((Layout)layout);
        final int max = this.fEditor.getStoryModel().getLength();
        this.offsetInput = new Spinner(input, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.offsetInput.setLayoutData((Object)data);
        this.offsetInput.setMinimum(0);
        this.offsetInput.setMaximum(max);
        this.offsetInput.setSelection(this.fDesc != null ? this.fDesc.getOffset() : this.fOffset);
        this.offsetInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DescEditingDialog.this.lengthInput.getSelection() > max - DescEditingDialog.this.offsetInput.getSelection()) {
                    DescEditingDialog.this.lengthInput.setSelection(max - DescEditingDialog.this.offsetInput.getSelection());
                }
                DescEditingDialog.this.validate();
            }
        });
        blank = new Label(input, 0);
        blank.setText("\t\t");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        blank.setLayoutData((Object)data);
        blank = new Label(input, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        blank.setLayoutData((Object)data);
        this.lengthInput = new Spinner(input, 2048);
        this.lengthInput.setLayoutData((Object)new GridData(768));
        this.lengthInput.setMinimum(0);
        this.lengthInput.setMaximum(this.fEditor.getStoryModel().getLength());
        this.lengthInput.setSelection(this.fDesc != null ? this.fDesc.getLength() : this.fLength);
        this.lengthInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DescEditingDialog.this.offsetInput.getSelection() > max - DescEditingDialog.this.lengthInput.getSelection()) {
                    DescEditingDialog.this.offsetInput.setSelection(max - DescEditingDialog.this.lengthInput.getSelection());
                }
                DescEditingDialog.this.validate();
            }
        });
        return composite;
    }

    public void validate() {
        if (this.offsetInput == null | this.lengthInput == null) {
            return;
        }
        this.fOffset = this.offsetInput.getSelection();
        this.fLength = this.lengthInput.getSelection();
        String id = this.repInput.getText();
        this.fRep = StoryPlugin.getDefault().getRepManager().getRep(id);
        try {
            if (this.fRep == null || this.fRep.getDataFormat() == null) {
                this.fData = null;
                this.disableDataInput();
            } else {
                this.enableDataInput();
                this.fData = this.fRep.reconstitute((IHasPosition)new SimplePosition(this.fOffset, this.fLength), this.dataInput.getText(), (IStoryModel)this.fEditor.getStoryModel());
            }
        }
        catch (Exception exception) {}
        if (this.fRep == null) {
            this.updateStatus((IStatus)new Status(4, " ", this.BAD_REP, "Representation cannot be null", null));
            return;
        }
        if (this.fRep.equals(this.fEditor.getStoryModel().getPrimary())) {
            this.updateStatus((IStatus)new Status(4, " ", this.BAD_REP, "You cannot create a primary description", null));
            return;
        }
        if (this.fData == null & this.fRep.getDataFormat() != null) {
            this.updateStatus((IStatus)new Status(4, " ", this.BAD_DATA, "Data is invalid for this representation", null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, " ", 0, "", null));
    }

    public boolean isDescriptionChanged() {
        if (this.fDesc == null) {
            return true;
        }
        if (this.fDesc.getOffset() != this.fOffset) {
            return true;
        }
        if (this.fDesc.getLength() != this.fLength) {
            return true;
        }
        return !this.fDesc.getData().equals(this.fData);
    }

    public IDesc getOriginalDescription() {
        return this.fDesc;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public IData getData() {
        return this.fData;
    }

    public IRep getRepresentation() {
        return this.fRep;
    }

    protected void enableDataInput() {
        if (this.dataInput.isEnabled()) {
            return;
        }
        if (this.fRep == null) {
            return;
        }
        if (this.fRep.getDataFormat() == null) {
            return;
        }
        this.dataInput.setEnabled(true);
        if (this.oldValue != null) {
            this.dataInput.setText(this.oldValue);
        }
    }

    protected void disableDataInput() {
        if (!this.dataInput.isEnabled()) {
            return;
        }
        this.dataInput.setEnabled(false);
        this.oldValue = this.dataInput.getText();
        this.dataInput.setText("");
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (this.fModel == null) {
            return;
        }
        if (status.getCode() != this.BAD_POSITION) {
            this.fModel.modifyAnnotationPosition(this.fPosAnnotation, new Position(this.fOffset, this.fLength));
        } else {
            this.fModel.modifyAnnotationPosition(this.fPosAnnotation, null);
        }
    }

    public boolean close() {
        if (this.fModel != null) {
            this.fModel.modifyAnnotationPosition(this.fPosAnnotation, null);
        }
        return super.close();
    }

    public void create() {
        super.create();
        this.validate();
    }
}

