/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import com.google.common.base.Joiner;
import edu.mit.story.core.agreement.AgreementResult;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.AgreementResultContentProvider;
import edu.mit.story.ui.label.AgreementResultLabelProvider;
import edu.mit.story.ui.label.NameLabelProvider;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgreementResultDisplayDialog
extends TrayDialog {
    private Map<String, List<IAgreementResult>> results = Collections.emptyMap();
    protected TreeViewer treeViewer;
    protected Button copyButton;
    protected ComboViewer copyStyleCombo;

    public AgreementResultDisplayDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setResults(Map<String, List<IAgreementResult>> results) {
        if (results == null) {
            results = Collections.emptyMap();
        }
        this.results = results;
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.setInput(results.entrySet());
            this.treeViewer.refresh();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Agreement");
        Composite treeComposite = new Composite(composite, 0);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeLayout);
        TreeViewer treeViewer = new TreeViewer(treeComposite, 2818);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setContentProvider((IContentProvider)new AgreementResultContentProvider());
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn colViewer = new TreeViewerColumn(treeViewer, 0);
        colViewer.getColumn().setResizable(true);
        colViewer.getColumn().setText("Name");
        treeLayout.setColumnData((Widget)colViewer.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        colViewer = new TreeViewerColumn(treeViewer, 0);
        colViewer.getColumn().setResizable(true);
        colViewer.getColumn().setText("Value");
        treeLayout.setColumnData((Widget)colViewer.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        colViewer = new TreeViewerColumn(treeViewer, 0);
        colViewer.getColumn().setResizable(true);
        colViewer.getColumn().setText("Representation");
        treeLayout.setColumnData((Widget)colViewer.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        treeViewer.setLabelProvider((IBaseLabelProvider)new AgreementResultLabelProvider());
        treeViewer.setInput(this.results.entrySet());
        treeViewer.expandToLevel(3);
        TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            col.pack();
            ++n2;
        }
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        Label spacer = new Label(buttonComposite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(buttonComposite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText("Header style:");
        this.copyStyleCombo = new ComboViewer(buttonComposite, 2056);
        this.copyStyleCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.copyStyleCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.copyStyleCombo.setInput((Object)AgreementResult.HeaderStyle.values());
        this.copyStyleCombo.setSelection((ISelection)new StructuredSelection((Object)AgreementResult.HeaderStyle.BOTTOM_RIGHT));
        this.copyButton = new Button(buttonComposite, 0);
        this.copyButton.setLayoutData((Object)new GridData(131072, 0, false, false));
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("Copy to clipboard");
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgreementResultDisplayDialog.this.copyToClipboard();
            }
        });
        return composite;
    }

    protected void copyToClipboard() {
        AgreementResult.HeaderStyle style = SelectionUtils.extractSingle(this.copyStyleCombo.getSelection(), AgreementResult.HeaderStyle.class);
        if (style == null) {
            style = AgreementResult.HeaderStyle.LEFT_TOP;
        }
        String[][] table = AgreementResult.convertToTable(this.results, (AgreementResult.HeaderStyle)style);
        Object[] rows = new String[table.length];
        int i = 0;
        while (i < table.length) {
            rows[i] = Joiner.on((char)'\t').join(table[i]);
            ++i;
        }
        String content = Joiner.on((char)'\n').join(rows);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(content), null);
    }

    public static int open(Shell shell, Map<String, List<IAgreementResult>> results) {
        AgreementResultDisplayDialog dialog = new AgreementResultDisplayDialog(shell);
        dialog.setResults(results);
        dialog.setBlockOnOpen(true);
        return dialog.open();
    }
}

