/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.ui.build.StoryNature;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import java.util.Collection;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepSelectionConsistentController<M extends IRepSelectionModel>
implements IRepSelectionController<M> {
    private final M model;

    public RepSelectionConsistentController(M model) {
        if (model == null) {
            throw new NullPointerException();
        }
        RepSelectionModel.checkConsistency(model);
        this.model = model;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void toggleSelected(IRep rep) {
        this.setSelected(rep, !this.model.isSelected(rep));
    }

    @Override
    public void toggleRequired(IRep rep) {
        this.setRequired(rep, !this.model.isRequired(rep));
    }

    @Override
    public void setSelected(IRep rep, boolean select) {
        if (!this.model.getSupported().contains(rep)) {
            return;
        }
        if (this.model.isRequired(rep)) {
            return;
        }
        if (select) {
            this.select(rep);
        } else {
            this.unselect(rep);
        }
    }

    @Override
    public void setRequired(IRep rep, boolean require) {
        if (!this.model.getSupported().contains(rep)) {
            return;
        }
        if (require) {
            this.require(rep);
        } else {
            this.unrequire(rep);
        }
    }

    protected void require(IRep rep) {
        IRepSet rs = RepUtils.getAllAntecedents((IRep)rep);
        for (IRep r : rs) {
            this.model.setRequired(r, true);
        }
        this.model.setRequired(rep, true);
    }

    protected void unrequire(IRep rep) {
        IRepSet rs = RepUtils.getAllDependents((IRep)rep, (IRepSupporter)new RepSet(this.model.getSupported()));
        this.model.setRequired(rep, false);
        for (IRep r : rs) {
            this.model.setRequired(r, false);
        }
    }

    protected void select(IRep rep) {
        IRepSet rs = RepUtils.getAllAntecedents((IRep)rep);
        for (IRep r : rs) {
            this.model.setSelected(r, true);
        }
        this.model.setSelected(rep, true);
    }

    protected void unselect(IRep rep) {
        IRepSet rs = RepUtils.getAllDependents((IRep)rep, (IRepSupporter)new RepSet(this.model.getSupported()));
        this.model.setSelected(rep, false);
        for (IRep r : rs) {
            this.model.setSelected(r, false);
        }
    }

    @Override
    public void loadProject(IProject project) {
        if (project == null || !project.exists()) {
            this.model.clear();
            return;
        }
        StoryNature nature = StoryNature.getStoryNature(project);
        if (nature == null) {
            this.model.clear();
            return;
        }
        this.model.getSupported().addAll((Collection<IRep>)nature.getSupported());
        for (IRep r : nature.getSupported()) {
            this.model.setSelected(r, true);
        }
        for (IRep r : nature.getRequired()) {
            this.model.setRequired(r, true);
        }
    }

    public void dispose() {
        this.model.dispose();
    }
}

