/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.clipboard;

import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.element.IStoryElementSet;
import edu.mit.story.ui.clipboard.StoryElementTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ClipboardUtils {
    public static IStoryElement getStoryObject(Clipboard clipboard) {
        if (clipboard == null) {
            return null;
        }
        return (IStoryElement)clipboard.getContents((Transfer)StoryElementTransfer.getInstance());
    }

    public static void putStoryObject(IStoryElement element, Clipboard clipboard) {
        if (element == null | clipboard == null) {
            return;
        }
        if (element.getImplementationCode() == 9) {
            element = ((IStoryElementSet)element).compress();
        }
        Object[] data = new Object[]{element};
        clipboard.setContents(data, new Transfer[]{StoryElementTransfer.getInstance()});
    }

    public static void putStoryObjectData(IStoryElement element, Clipboard clipboard) {
        if (element == null | clipboard == null) {
            return;
        }
        String string = element.getSerializedData();
        if (string == null) {
            return;
        }
        Object[] data = new Object[]{string};
        clipboard.setContents(data, new Transfer[]{TextTransfer.getInstance()});
    }
}

