/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.build;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.build.AbstractBaseBuildRule;
import edu.mit.story.core.build.IBaseBuildRule;
import edu.mit.story.core.build.IBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModelImporter;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.ImmutableHasPositionSet;
import edu.mit.story.ui.build.IContextBuildRule;
import edu.mit.story.ui.build.StoryFilesVisitor;
import edu.mit.story.ui.build.StoryNature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.util.SafeRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryBuilder
extends IncrementalProjectBuilder {
    public static final String SHOW_ALL_PROBLEMS = "SHOW_ALL_PROBLEMS";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6 || kind == 15) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Performing clean", 10);
        monitor.subTask("Calculating files to be cleaned");
        HashSet<IResource> storyFiles = new HashSet<IResource>();
        this.getProject().accept((IResourceVisitor)new StoryFilesVisitor(storyFiles));
        monitor.worked(1);
        monitor = new SubProgressMonitor(monitor, 9);
        monitor.beginTask("Cleaning files", storyFiles.size());
        for (IResource r : storyFiles) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.clean(r);
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Performing full build", 1000);
        monitor.subTask("Calculating files to be built");
        HashSet<IResource> changed = new HashSet<IResource>();
        try {
            this.getProject().accept((IResourceVisitor)new StoryFilesVisitor(changed));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        monitor.worked(1);
        this.buildFiles(changed, (IProgressMonitor)new SubProgressMonitor(monitor, 999));
        monitor.done();
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Performing incremental build", 10);
        monitor.subTask("Calculating files to be built");
        HashSet<IResource> changed = new HashSet<IResource>();
        try {
            delta.accept((IResourceDeltaVisitor)new StoryFilesVisitor(changed));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        monitor.worked(1);
        this.buildFiles(changed, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        monitor.done();
    }

    protected void buildFiles(Set<IResource> changed, IProgressMonitor monitor) throws CoreException {
        StoryNature nature = StoryNature.getStoryNature(this.getProject());
        for (IBaseBuildRule iBaseBuildRule : nature.getBuildRules()) {
            iBaseBuildRule.setCompressing(false);
        }
        for (IBaseBuildRule iBaseBuildRule : nature.getContextBuildRules()) {
            iBaseBuildRule.setCompressing(false);
        }
        monitor.beginTask("", changed.size());
        for (IResource iResource : changed) {
            monitor.subTask("Building " + iResource.getName());
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.clean(iResource);
            this.build(iResource);
            monitor.worked(1);
        }
        monitor.done();
    }

    protected void clean(IResource r) throws CoreException {
        if (r.exists()) {
            r.deleteMarkers("edu.mit.story.core.marker.story", true, 2);
        }
    }

    protected void build(IResource r) throws CoreException {
        List<Object> rules;
        if (!r.exists()) {
            return;
        }
        if (r.getType() != 1) {
            return;
        }
        StoryNature nature = StoryNature.getStoryNature(this.getProject());
        List<Object> contextRules = nature == null ? Collections.emptyList() : nature.getContextBuildRules();
        List<Object> list = rules = nature == null ? Collections.emptyList() : nature.getBuildRules();
        if (contextRules.isEmpty() && rules.isEmpty()) {
            return;
        }
        IFile f = (IFile)r;
        ArrayList results = new ArrayList(1);
        IMutableStoryModel model = StoryModelImporter.extractModel((IFile)f, results);
        if (model == null) {
            StoryPlugin.getDefault().getLog().log((IStatus)results.get(0));
            return;
        }
        Iterator i = model.getData().iterator();
        while (i.hasNext()) {
            if (((IDesc)i.next()).getData() != null) continue;
            i.remove();
        }
        BuildRuleSafeRunner runnable = new BuildRuleSafeRunner((IStoryModel)model, nature);
        for (IContextBuildRule iContextBuildRule : contextRules) {
            if (!model.supports(iContextBuildRule.getRep())) continue;
            runnable.setContextBuildRule(iContextBuildRule);
            SafeRunnable.run((ISafeRunnable)runnable);
            if (runnable.getProblems().isEmpty()) {
                AbstractBaseBuildRule.markChecked((IResource)r, (IBaseBuildRule)iContextBuildRule);
                continue;
            }
            for (IStoryProblem problem : runnable.getProblems()) {
                StoryProblem.markProblem((IResource)r, (IStoryProblem)problem);
            }
        }
        for (IBuildRule iBuildRule : rules) {
            if (!model.supports(iBuildRule.getRep())) continue;
            runnable.setBuildRule(iBuildRule);
            SafeRunnable.run((ISafeRunnable)runnable);
            if (runnable.getProblems().isEmpty()) {
                AbstractBaseBuildRule.markChecked((IResource)r, (IBaseBuildRule)iBuildRule);
                continue;
            }
            for (IStoryProblem problem : runnable.getProblems()) {
                StoryProblem.markProblem((IResource)r, (IStoryProblem)problem);
            }
        }
    }

    public static void addStoryBuilder(IProject project) throws CoreException {
        ICommand[] cmds;
        if (project == null) {
            return;
        }
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = cmds = description.getBuildSpec();
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals("edu.mit.story.ui.builder")) {
                return;
            }
            ++n2;
        }
        ICommand newCmd = description.newCommand();
        newCmd.setBuilderName("edu.mit.story.ui.builder");
        ICommand[] newCmds = new ICommand[cmds.length + 1];
        System.arraycopy(cmds, 0, newCmds, 0, cmds.length);
        newCmds[cmds.length] = newCmd;
        description.setBuildSpec(newCmds);
        project.setDescription(description, null);
    }

    public static void removeStoryBuilder(IProject project) throws CoreException {
        if (project == null) {
            return;
        }
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("edu.mit.story.ui.builder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuildRuleSafeRunner
    extends SafeRunnable {
        private final IStoryModel model;
        private final StoryNature nature;
        private IBuildRule rule;
        private IContextBuildRule contextRule;
        private IHasPositionSet<IStoryProblem> problems;

        public BuildRuleSafeRunner(IStoryModel model, StoryNature nature) {
            if (model == null) {
                throw new NullPointerException();
            }
            if (nature == null) {
                throw new NullPointerException();
            }
            this.model = model;
            this.nature = nature;
        }

        public void setBuildRule(IBuildRule rule) {
            this.rule = rule;
            this.contextRule = null;
        }

        public void setContextBuildRule(IContextBuildRule rule) {
            this.rule = null;
            this.contextRule = rule;
        }

        public IHasPositionSet<IStoryProblem> getProblems() {
            return this.problems;
        }

        public void run() throws Exception {
            this.problems = ImmutableHasPositionSet.emptySet();
            if (this.rule != null) {
                this.problems = this.rule.build(this.model);
            } else if (this.contextRule != null) {
                this.problems = this.contextRule.build(this.model, this.nature);
            }
            if (this.problems == null) {
                this.problems = ImmutableHasPositionSet.emptySet();
            }
        }
    }
}

