/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.groups;

import edu.mit.story.ui.actions.generic.DeleteDescAction;
import edu.mit.story.ui.actions.generic.EditDescAction;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.items.CommandHooks;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.services.IServiceLocator;

public class EditDescriptionGroup
extends ActionGroup
implements IHasStoryEditor {
    IStoryEditor editor;
    EditDescAction editAction;
    DeleteDescAction deleteAction;
    IContributionItem recalcAction;

    public EditDescriptionGroup(IStoryEditor editor, ISelectionProvider provider) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.editAction = new EditDescAction(editor, provider);
        this.deleteAction = new DeleteDescAction(editor, provider);
        this.recalcAction = CommandHooks.createRecalculate((IServiceLocator)editor.getEditorSite());
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.appendToGroup("group.edit", (IAction)this.editAction);
        menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        menu.appendToGroup("group.edit", this.recalcAction);
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    public void setStoryEditor(IStoryEditor editor) {
        this.editAction.setStoryEditor(editor);
        this.deleteAction.setStoryEditor(editor);
    }
}

