/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.generic;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class EditDescAction
extends ResourceAction2
implements IHasStoryEditor,
ISelectionChangedListener {
    IStoryEditor editor;
    ISelectionProvider provider;

    public EditDescAction(IStoryEditor editor, ISelectionProvider provider) {
        super(StoryUIMessages.getBundle(), StoryUIMessages.ACTION_EditDescription_prefix);
        this.setStoryEditor(editor);
        this.provider = provider;
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void run() {
        DescActionUtils.editDescription(this, SelectionUtils.extractFirst(this.provider.getSelection(), IDesc.class), this.editor);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        this.editor = newEditor;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IDesc description = SelectionUtils.extractFirst(this.provider.getSelection(), IDesc.class);
        this.setEnabled(DescActionUtils.canEdit(description, this.editor));
    }
}

