/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.generic;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class DeleteDescAction
extends DeleteAction
implements IHasStoryEditor,
ISelectionChangedListener {
    IStoryEditor editor;
    ISelectionProvider provider;

    public DeleteDescAction(IStoryEditor editor, ISelectionProvider provider) {
        this.setStoryEditor(editor);
        this.provider = provider;
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void doDelete() {
        List<IDesc> descs = SelectionUtils.extractAll(this.provider.getSelection(), IDesc.class);
        if (!descs.isEmpty()) {
            DescActionUtils.doDelete((Object)this, descs, (IMutableStoryModel)this.editor.getStoryModel());
            return;
        }
        List<IMetaDesc> metadescs = SelectionUtils.extractAll(this.provider.getSelection(), IMetaDesc.class);
        if (!metadescs.isEmpty()) {
            ArrayList<IMetaDesc> toDelete = new ArrayList<IMetaDesc>(metadescs.size());
            for (IMetaDesc md : metadescs) {
                toDelete.add(md);
            }
            RemoveMetadataChange change = new RemoveMetadataChange(toDelete);
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
            return;
        }
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        this.editor = newEditor;
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        List<IDesc> descs = SelectionUtils.extractAll(this.provider.getSelection(), IDesc.class);
        if (!descs.isEmpty()) {
            this.setEnabled(true);
            return;
        }
        List<IMetaDesc> metadescs = SelectionUtils.extractAll(this.provider.getSelection(), IMetaDesc.class);
        if (!metadescs.isEmpty()) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

