/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import org.eclipse.jface.dialogs.IMessageProvider;

public class Message
implements IMessageProvider {
    public static final Message NO_MESSAGE = new Message();
    private final String message;
    private final int type;

    protected Message() {
        this(null, 0);
    }

    public Message(IMessageProvider message) {
        this(message.getMessage(), message.getMessageType());
    }

    public Message(String message, int type) {
        Message.checkType(type);
        this.message = message;
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.type;
    }

    public static boolean isValidType(int type) {
        return type == 0 || type == 3 || type == 1 || type == 2;
    }

    public static void checkType(int type) {
        if (!Message.isValidType(type)) {
            throw new IllegalArgumentException("invalid message type: " + type);
        }
    }
}

