/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.IStoryConstants;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.validation.BaseValidator;
import edu.mit.story.core.validation.IDescriptorListValidator;
import java.util.AbstractList;
import java.util.List;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerBackedListValidator
extends BaseValidator<String>
implements IDescriptorListValidator<String> {
    IManager<?> manager;
    List<String> valueList;

    public ManagerBackedListValidator(IManager<?> manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
    }

    @Override
    public List<String> getValueList() {
        if (this.valueList == null) {
            this.valueList = new ValueViewList();
        }
        return this.valueList;
    }

    @Override
    public List<? extends IDescriptor> getDescriptors() {
        return this.manager.getDescriptors();
    }

    @Override
    public boolean isRestrictedToList() {
        return true;
    }

    @Override
    public IMessageProvider validate(String value) {
        if (value == null) {
            return IStoryConstants.noNullValues;
        }
        for (IDescriptor iDescriptor : this.getDescriptors()) {
            if (!iDescriptor.getID().equals(value)) continue;
            return null;
        }
        return IStoryConstants.invalidValue;
    }

    public boolean isValueIDs() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueViewList
    extends AbstractList<String> {
        protected ValueViewList() {
        }

        @Override
        public String get(int index) {
            return ((IDescriptor)ManagerBackedListValidator.this.manager.getDescriptors().get(index)).getID();
        }

        @Override
        public int size() {
            return ManagerBackedListValidator.this.manager.getDescriptors().size();
        }
    }
}

