/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.property.FreeConfiguration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IFreeConfiguration;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.core.xml.IHasParserHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLUtils
implements IUtilityClass {
    public static final String genericXMLPrefix = "<?xml";
    private static Transformer transformer;
    private static DocumentBuilderFactory factory;
    private static DocumentBuilder builder;
    private static DOMImplementation implementation;

    private XMLUtils() {
    }

    public static Document createEmptyDocument(String rootTag) {
        DOMImplementation impl = XMLUtils.getDOMImplementation();
        DocumentType type = impl.createDocumentType(rootTag, null, null);
        return impl.createDocument(null, rootTag, type);
    }

    public static Transformer getTransformer() {
        if (transformer == null) {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setAttribute("indent-number", "2");
                transformer = transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            transformer.setOutputProperty("indent", "yes");
        }
        return transformer;
    }

    public static DocumentBuilderFactory getBuilderFactory() {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        return factory;
    }

    public static DocumentBuilder getBuilder() {
        if (builder == null) {
            try {
                builder = XMLUtils.getBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return builder;
    }

    public static DOMImplementation getDOMImplementation() {
        if (implementation == null) {
            implementation = builder.getDOMImplementation();
        }
        return implementation;
    }

    public static Document fromString(String xml) {
        String trimmed = xml.trim();
        if (!trimmed.startsWith(genericXMLPrefix)) {
            return null;
        }
        return XMLUtils.fromString(new StringReader(xml));
    }

    public static Document fromString(Reader xmlReader) {
        InputSource is = new InputSource(xmlReader);
        try {
            return XMLUtils.getBuilder().parse(is);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toString(Document xml) {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(xml);
        try {
            XMLUtils.getTransformer().transform(source, result);
        }
        catch (Exception exception) {
            return null;
        }
        return writer.toString();
    }

    public static InputStream toStream(Document xml) {
        StringWriter writer = new StringWriter();
        try {
            XMLUtils.getTransformer().transform(new DOMSource(xml), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(writer.toString().getBytes());
    }

    public static Element putElement(Node parent, Element child) {
        if (parent == null || child == null) {
            return null;
        }
        parent.appendChild(child);
        return child;
    }

    public static Element toXML(String elementType, String id, Document doc) {
        if (id == null || doc == null || elementType.length() == 0) {
            return null;
        }
        Element configNode = doc.createElement(elementType);
        configNode.setAttribute("id", id);
        return configNode;
    }

    public static Element toXML(String elementType, IConfiguration config, Document doc) {
        Element configNode = XMLUtils.toXML(elementType, config.getID(), doc);
        if (configNode == null) {
            return null;
        }
        return XMLUtils.toXML(configNode, config, doc);
    }

    public static Element toXML(Element parent, IConfiguration config, Document doc) {
        for (Map.Entry entry : config.entrySet()) {
            Element paramNode = doc.createElement("param");
            IConfiguration paramConfig = config.getConfiguration((String)entry.getKey());
            if (paramConfig != null) {
                XMLUtils.toXML(paramNode, paramConfig, doc);
            }
            paramNode.setAttribute((String)entry.getKey(), (String)entry.getValue());
            parent.appendChild(paramNode);
        }
        return parent;
    }

    public static String extractID(Node node) {
        return node.getAttributes().getNamedItem("id").getNodeValue();
    }

    public static IFreeConfiguration extractConfiguration(Node node) {
        String id = XMLUtils.extractID(node);
        return XMLUtils.extractConfiguration(id, node);
    }

    protected static IFreeConfiguration extractConfiguration(String id, Node node) {
        FreeConfiguration result = new FreeConfiguration(id);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node attr;
            Node child = children.item(i);
            if (child.getNodeName().equals("param") && (attr = child.getAttributes().item(0)) != null) {
                String key = attr.getNodeName();
                String value = attr.getNodeValue();
                IFreeConfiguration config = XMLUtils.extractConfiguration(value, child);
                result.put(key, value);
                if (!config.isEmpty()) {
                    result.getConfigurations().put(key, config);
                }
            }
            ++i;
        }
        return result;
    }

    public static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static void parse(IHasParserHandler handler, IFile f) {
        InputSource is = null;
        try {
            is = new InputSource(f.getContents());
        }
        catch (CoreException e) {
            Status status = new Status(4, "edu.mit.story.core", "Problem reading file " + f.getFullPath().toPortableString(), (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            return;
        }
        XMLReader parser = XMLUtils.createXMLReader();
        handler.setParser(parser);
        parser.setContentHandler(handler);
        try {
            parser.parse(is);
        }
        catch (Exception e) {
            Status status = new Status(4, "edu.mit.story.core", "Problem parsing file " + f.getFullPath().toPortableString(), (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

