/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedKeySet<K, V>
extends AbstractSet<K>
implements SortedSet<K> {
    private final SortedMap<K, V> backingMap;

    public SortedKeySet(SortedMap<K, V> backingMap) {
        if (backingMap == null) {
            throw new NullPointerException();
        }
        this.backingMap = backingMap;
    }

    protected SortedMap<K, V> getBackingMap() {
        return this.backingMap;
    }

    @Override
    public Iterator<K> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.backingMap.keySet().size();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.backingMap.comparator();
    }

    @Override
    public K first() {
        return this.backingMap.firstKey();
    }

    @Override
    public K last() {
        return this.backingMap.lastKey();
    }

    @Override
    public SortedSet<K> headSet(K toElement) {
        SortedMap<K, V> submap = this.backingMap.headMap(toElement);
        return new SortedKeySet<K, V>(submap);
    }

    @Override
    public SortedSet<K> subSet(K fromElement, K toElement) {
        SortedMap<K, V> submap = this.backingMap.subMap(fromElement, toElement);
        return new SortedKeySet<K, V>(submap);
    }

    @Override
    public SortedSet<K> tailSet(K fromElement) {
        SortedMap<K, V> submap = this.backingMap.tailMap(fromElement);
        return new SortedKeySet<K, V>(submap);
    }
}

