/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntriesKeyListView<K>
extends AbstractList<K>
implements List<K> {
    private final Collection<? extends Map.Entry<? extends K, ?>> backing;
    private final List<? extends Map.Entry<? extends K, ?>> backingList;

    public EntriesKeyListView(Collection<? extends Map.Entry<? extends K, ?>> backing) {
        this.backing = backing;
        this.backingList = backing instanceof List ? (List)backing : null;
    }

    @Override
    public K get(int index) {
        Map.Entry<? extends K, ?> entry;
        if (this.backingList != null) {
            entry = this.backingList.get(index);
        } else {
            try {
                Iterator<Map.Entry<K, ?>> itr = this.backing.iterator();
                int i = 0;
                while (i < index) {
                    itr.next();
                    ++i;
                }
                entry = itr.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public Iterator<K> iterator() {
        return new EntriesKeyListIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntriesKeyListIterator
    implements Iterator<K> {
        protected Iterator<? extends Map.Entry<? extends K, ?>> backingItr;

        protected EntriesKeyListIterator() {
            this.backingItr = EntriesKeyListView.this.backing.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.backingItr.hasNext();
        }

        @Override
        public K next() {
            Map.Entry entry = this.backingItr.next();
            return entry == null ? null : (Object)entry.getKey();
        }

        @Override
        public void remove() {
            this.backingItr.remove();
        }
    }
}

