/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.text.IndexedTextType;
import edu.mit.story.core.rep.text.RegionTokenizer;
import edu.mit.story.core.rep.text.TextRep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDescFactory
extends AbstractDescFactory2<IndexedTextType> {
    public TextDescFactory() {
        super(TextRep.getInstance(), CharRep.getInstance());
    }

    @Override
    protected IDescSet doCalculateDescriptions(IHasPosition range, IStoryModel provider) {
        DescSet result = new DescSet(this.getRep());
        if (range == null | provider == null) {
            return result;
        }
        SimplePosition newRange = new SimplePosition(0, range.getRightOffset());
        IHasPositionSet<IndexedTextType> indexedData = this.calculateData(newRange, provider);
        if (indexedData == null) {
            return result;
        }
        for (IndexedTextType data : indexedData.openSet(range)) {
            result.add(this.toDescription(data, provider));
        }
        return result;
    }

    @Override
    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        IntervalSet result = new IntervalSet();
        result.add(new SimplePosition(0, event.provider.getLength()));
        return result;
    }

    @Override
    protected IHasPositionSet<IndexedTextType> calculateData(IHasPosition region, IStoryModel provider) {
        HasPositionSet<IndexedTextType> result = new HasPositionSet<IndexedTextType>();
        ICharStore store = CharRep.extractCharStore(provider.getData());
        if (store == null) {
            return result;
        }
        int minLength = TextRep.getInstance().getMinimumDescriptionLength();
        int index = region.getOffset();
        while (index < region.getRightOffset()) {
            IndexedTextType textRegion = RegionTokenizer.findNextRegion(index, store);
            if (textRegion == null || region.getRightOffset() < textRegion.getOffset()) break;
            index = textRegion.getRightOffset();
            if (textRegion.getRightOffset() <= region.getOffset() || textRegion.getLength() < minLength) continue;
            result.add(textRegion);
        }
        return result;
    }
}

