/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.character.changes.CharChange;
import edu.mit.story.core.rep.text.IndexedTextType;
import edu.mit.story.core.rep.text.ParagraphBoundDetector;
import edu.mit.story.core.rep.text.RegionTokenizer;
import edu.mit.story.core.rep.text.TextRegion;
import edu.mit.story.core.rep.text.WhitespaceDetector;
import edu.mit.story.core.rep.text.WhitespaceStringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.rules.IWhitespaceDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflowTextChange
extends AbstractModelChange {
    static final String empty = "";
    static final String delimiter = "\n";
    static final String twoDelimiters = "\n\n";
    static final String interTokenSpace = " ";
    static final String singleStart = "// ";
    static final String singleNewLineStart = "\n// ";
    static final String multiRegionStartParagraphStart = "/** ";
    static final String multiLineStart = "\n * ";
    static final String multiIntraRegionParagraphEnd = " *\n";
    static final String multiRegionEndParagraphEnd = " */";
    static final String multiTextEnd = " */";
    static final char[] commentChars = new char[]{'*', '/'};
    static final IWhitespaceDetector textDetector = new WhitespaceDetector();
    static final IWhitespaceDetector singleDetector = new WhitespaceDetector(TextRegion.SINGLE.getIgnoredChars());
    static final IWhitespaceDetector multiDetector = new WhitespaceDetector(TextRegion.MULTI.getIgnoredChars());
    final int fOffset;
    final int fRightOffset;
    final int fLength;
    final int fWidth;

    public ReflowTextChange(int maxLineWidth) {
        this(-1, 0, maxLineWidth);
    }

    public ReflowTextChange(int offset, int length, int maxLineWidth) {
        super(StoryMessages.CHANGE_NAME_Reflow);
        if (offset < -1 || length < 0 || maxLineWidth <= 0) {
            throw new IllegalArgumentException();
        }
        this.fOffset = offset;
        this.fLength = length;
        this.fRightOffset = offset + length;
        this.fWidth = maxLineWidth;
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
        IStoryData descMap = provider.getData();
        ICharStore store = CharRep.extractCharStore(descMap);
        if (store == null) {
            return null;
        }
        List<IndexedTextType> regions = this.getTextRegions(store, descMap);
        if (regions.isEmpty()) {
            return null;
        }
        int[] bounds = this.calculateBounds(store, regions);
        int left = bounds[0];
        int right = bounds[1];
        int adjust = 0;
        StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(source, provider);
        int i = 0;
        while (i < regions.size()) {
            int rRight;
            IndexedTextType region = regions.get(i);
            int rLeft = Math.max(region.getOffset(), left);
            if (rLeft < (rRight = Math.min(region.getRightOffset(), right))) {
                int pLeft = rLeft;
                int pRight = ParagraphBoundDetector.findRightBound(pLeft, store, region);
                while (pLeft < rRight) {
                    adjust = 0;
                    if (region.getData() == TextRegion.TEXT) {
                        adjust = this.reflowTextParagraph(pLeft, pRight, region, store, descMap, integrator);
                    } else if (region.getData() == TextRegion.SINGLE) {
                        adjust = this.reflowSingleParagraph(pLeft, pRight, region, store, descMap, integrator);
                    } else if (region.getData() == TextRegion.MULTI) {
                        adjust = this.reflowMultiParagraph(pLeft, pRight, region, store, descMap, integrator);
                    }
                    if (adjust != 0) {
                        right += adjust;
                        rRight += adjust;
                        pRight += adjust;
                        int j = i + 1;
                        while (j < regions.size()) {
                            regions.get(j).setOffset(regions.get(j).getOffset() + adjust);
                            ++j;
                        }
                    }
                    pLeft = pRight;
                    pRight = ParagraphBoundDetector.findRightBound(pLeft, store, region);
                }
            }
            ++i;
        }
        return integrator.asEvent();
    }

    protected List<IndexedTextType> getTextRegions(ITextStore store, IDescMultiSet map) {
        int left = 0;
        ArrayList<IndexedTextType> regions = new ArrayList<IndexedTextType>();
        IndexedTextType region = RegionTokenizer.findNextRegion(left, store);
        while (region != null) {
            regions.add(region);
            if (region.getRightOffset() == store.getLength()) break;
            left = region.getRightOffset();
            region = RegionTokenizer.findNextRegion(left, store);
        }
        return regions;
    }

    protected int[] calculateBounds(ITextStore store, List<IndexedTextType> regions) {
        int right;
        int left;
        if (this.fOffset < 0) {
            left = 0;
            right = store.getLength();
        } else {
            IndexedTextType region;
            Iterator<IndexedTextType> i = regions.iterator();
            while (i.hasNext()) {
                region = i.next();
                if (!(region.getRightOffset() <= this.fOffset & i.hasNext())) continue;
                i.remove();
            }
            IndexedTextType leftRegion = regions.get(0);
            left = ParagraphBoundDetector.findLeftBound(this.fOffset, store, leftRegion);
            i = regions.iterator();
            i.next();
            while (i.hasNext()) {
                region = i.next();
                if (this.fRightOffset >= region.getOffset()) continue;
                i.remove();
            }
            IndexedTextType rightRegion = regions.get(regions.size() - 1);
            right = ParagraphBoundDetector.findRightBound(this.fRightOffset, store, rightRegion);
        }
        return new int[]{left, right};
    }

    protected boolean isPreviousString(String prev, int start, ITextStore store) {
        int idx = start;
        int prevIdx = prev.length() - 1;
        while (idx >= 0) {
            char p;
            char c = store.get(idx);
            if (c != (p = prev.charAt(prevIdx))) {
                return false;
            }
            if (prevIdx == 0) {
                return true;
            }
            --prevIdx;
            --idx;
        }
        return false;
    }

    protected boolean isNextString(String next, int start, ITextStore store) {
        int idx = start;
        int nextIdx = 0;
        while (idx < store.getLength()) {
            if (store.get(idx) != next.charAt(nextIdx)) {
                return false;
            }
            if (nextIdx == next.length() - 1) {
                return true;
            }
            ++nextIdx;
            ++idx;
        }
        return false;
    }

    protected int reflowTextParagraph(int left, int right, IndexedTextType region, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator) {
        if (left >= right) {
            return 0;
        }
        int totalAdjust = 0;
        String startingString = empty;
        if (left > 0 & left == region.getOffset()) {
            String whitespace = this.getLeadingWhitespace(left, right, store, textDetector);
            int count = this.countInstances(whitespace, delimiter);
            if (count == 1) {
                startingString = delimiter;
            } else if (count >= 2) {
                startingString = twoDelimiters;
            }
        }
        int adjust = this.reduceLeadingWhitespace(left, right, store, repMap, integrator, textDetector, startingString);
        right += adjust;
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        adjust = this.reduceInsideWhitespace(left, right, store, repMap, integrator, textDetector, interTokenSpace, delimiter);
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        String trailingString = store.getLength() <= (right += adjust) ? empty : twoDelimiters;
        adjust = this.reduceTrailingWhitespace(left, right, store, repMap, integrator, textDetector, trailingString);
        right += adjust;
        region.setLength(region.getLength() + adjust);
        return totalAdjust += adjust;
    }

    protected int countInstances(String string, String instance) {
        if (string == null) {
            return 0;
        }
        return string.split(instance, -1).length - 1;
    }

    protected int reflowSingleParagraph(int left, int right, IndexedTextType region, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator) {
        if (left >= right) {
            return 0;
        }
        int totalAdjust = 0;
        int adjust = this.reduceLeadingWhitespace(left, right, store, repMap, integrator, singleDetector, singleStart);
        right += adjust;
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        adjust = this.reduceInsideWhitespace(left, right, store, repMap, integrator, singleDetector, interTokenSpace, singleNewLineStart);
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        String trailingString = (right += adjust) == store.getLength() ? empty : delimiter;
        adjust = this.reduceTrailingWhitespace(left, right, store, repMap, integrator, singleDetector, trailingString);
        right += adjust;
        region.setLength(region.getLength() + adjust);
        return totalAdjust += adjust;
    }

    protected int reflowMultiParagraph(int left, int right, IndexedTextType region, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator) {
        if (left >= right) {
            return 0;
        }
        int totalAdjust = 0;
        String startingString = left == region.getOffset() ? multiRegionStartParagraphStart : multiLineStart;
        int adjust = this.reduceLeadingWhitespace(left, right, store, repMap, integrator, multiDetector, startingString);
        right += adjust;
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        adjust = this.reduceInsideWhitespace(left, right, store, repMap, integrator, multiDetector, interTokenSpace, multiLineStart);
        totalAdjust += adjust;
        region.setLength(region.getLength() + adjust);
        String trailingString = (right += adjust) < region.getRightOffset() ? multiIntraRegionParagraphEnd : (right < store.getLength() ? " */" + (this.isNextString(delimiter, right, store) ? empty : delimiter) : " */");
        adjust = this.reduceTrailingWhitespace(left, right, store, repMap, integrator, multiDetector, trailingString);
        right += adjust;
        region.setLength(region.getLength() + adjust);
        return totalAdjust += adjust;
    }

    protected int reduceLeadingWhitespace(int left, int right, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator, IWhitespaceDetector detector, String beginning) {
        String whitespace = this.getLeadingWhitespace(left, right, store, detector);
        if (whitespace.equals(beginning)) {
            return 0;
        }
        CharChange change = new CharChange(left, whitespace.length(), beginning);
        integrator.addEvent(change.apply(integrator.getSource(), integrator.getModel()));
        return beginning.length() - whitespace.length();
    }

    protected String getLeadingWhitespace(int left, int right, ITextStore store, IWhitespaceDetector detector) {
        if (left >= right) {
            return empty;
        }
        int whitespaceLength = 0;
        int i = left;
        while (i < right) {
            if (!detector.isWhitespace(store.get(i))) break;
            ++whitespaceLength;
            ++i;
        }
        return store.get(left, whitespaceLength);
    }

    protected int reduceInsideWhitespace(int left, int right, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator, IWhitespaceDetector detector, String betweenTokenSpace, String delim) {
        String spacePlusDelimiter = String.valueOf(betweenTokenSpace) + delim;
        int betweenTokenSpaceLength = betweenTokenSpace.length();
        int delimiterLength = delim.length();
        int spacePlusDelimiterLength = spacePlusDelimiter.length();
        int currentLineWidth = 0;
        int lineDelimiterIdx = 0;
        while (left < right & left < store.getLength()) {
            char c = store.get(left);
            if (!detector.isWhitespace(c)) break;
            ++left;
            lineDelimiterIdx = delim.charAt(lineDelimiterIdx) == c ? ++lineDelimiterIdx : 0;
            if (lineDelimiterIdx == delimiterLength) {
                lineDelimiterIdx = 0;
                currentLineWidth = 0;
                continue;
            }
            ++currentLineWidth;
        }
        if (left >= right) {
            return 0;
        }
        String paragraph = store.get(left, right - left);
        String token = empty;
        WhitespaceStringTokenizer tokenizer = new WhitespaceStringTokenizer(paragraph, detector);
        boolean needsLineBreak = false;
        int adjust = 0;
        int wsLeft = left;
        int wsRight = left;
        while (tokenizer.hasMoreTokens()) {
            int numChars = 0;
            if (needsLineBreak) {
                currentLineWidth = token.length();
            }
            wsRight = wsLeft = wsRight + token.length() + numChars;
            token = tokenizer.nextToken();
            while (store.get(wsRight) != token.charAt(0) & wsRight <= right) {
                ++wsRight;
            }
            int lineLengthAddition = tokenizer.hasMoreTokens() ? 2 * betweenTokenSpaceLength + token.length() : betweenTokenSpaceLength + token.length();
            needsLineBreak = this.fWidth < currentLineWidth + lineLengthAddition;
            currentLineWidth += betweenTokenSpaceLength + token.length();
            if (wsLeft == wsRight) continue;
            int wsLength = wsRight - wsLeft;
            String whitespace = store.get(wsLeft, wsLength);
            if (whitespace.equals(needsLineBreak ? spacePlusDelimiter : betweenTokenSpace)) continue;
            CharChange change = new CharChange(wsLeft, wsLength, needsLineBreak ? spacePlusDelimiter : betweenTokenSpace);
            integrator.addEvent(change.apply(integrator.getSource(), integrator.getModel()));
            numChars = (needsLineBreak ? spacePlusDelimiterLength : betweenTokenSpaceLength) - wsLength;
            wsRight += numChars;
            right += numChars;
            adjust += numChars;
        }
        return adjust;
    }

    protected int reduceTrailingWhitespace(int left, int right, ITextStore store, IDescMultiSet repMap, StoryChangeEventIntegrator integrator, IWhitespaceDetector detector, String ending) {
        String whitespace = this.getTrailingWhitespace(left, right, store, detector);
        if (whitespace.equals(ending)) {
            return 0;
        }
        int wsOffset = right - whitespace.length();
        CharChange change = new CharChange(wsOffset, whitespace.length(), ending);
        integrator.addEvent(change.apply(integrator.getSource(), integrator.getModel()));
        return ending.length() - whitespace.length();
    }

    protected String getTrailingWhitespace(int left, int right, ITextStore store, IWhitespaceDetector detector) {
        int whitespaceLength = 0;
        int idx = left;
        idx = right - 1;
        while (idx >= left) {
            if (!detector.isWhitespace(store.get(idx))) break;
            ++whitespaceLength;
            --idx;
        }
        return store.get(right - whitespaceLength, whitespaceLength);
    }
}

