/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.character.changes;

import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.character.CharRep;

public class SetEditableChange
extends AbstractModelChange {
    private final boolean editable;

    public SetEditableChange(boolean editable) {
        super("Set Text Editing");
        this.editable = editable;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        IConfiguration config = model.getData().getConfiguration(CharRep.getInstance());
        boolean isEditable = Boolean.parseBoolean((String)config.get("editable"));
        if (isEditable == this.editable) {
            return null;
        }
        config.put("editable", this.editable ? Boolean.toString(true) : Boolean.toString(false));
        Change change = new Change(Flag.CONFIG_CHANGED, (IHasPosition[])new IStoryModel[]{model});
        return new StoryChangeEvent(source, model, CharRep.getInstance(), change, (IModelChange)this, (IModelChange)new SetEditableChange(!this.editable));
    }
}

