/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.character.changes;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import org.eclipse.jface.text.DocumentEvent;

public class CharChange
extends AbstractModelChange {
    public final int replaceOffset;
    public final int replacedLength;
    public final int insertLength;
    public final String insertText;

    public CharChange(DocumentEvent event) {
        this(event.getOffset(), event.getLength(), event.getText());
    }

    public CharChange(int replaceOffset, int replaceLength, String insertText) {
        super(StoryMessages.CHANGE_NAME_Typing);
        if (insertText == null) {
            throw new NullPointerException();
        }
        this.replaceOffset = replaceOffset;
        this.replacedLength = replaceLength;
        this.insertLength = insertText.length();
        this.insertText = insertText;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        if (this.insertText.length() == 0 && this.replacedLength == 0) {
            return null;
        }
        IStoryData data = model.getData();
        IDesc oldDesc = CharRep.extractCharDescription(data);
        ICharStore store = CharRep.extractCharStore(oldDesc);
        if (store == null) {
            return null;
        }
        String oldText = store.get(this.replaceOffset, this.replacedLength);
        if (oldText.equals(this.insertText)) {
            return null;
        }
        store.replace(this.replaceOffset, this.replacedLength, this.insertText);
        data.remove(oldDesc);
        Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), 0, store.getLength(), store, oldDesc.getMetaData());
        newDesc.getMetaData().addDesc(new MetaDesc<Origin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
        data.add(newDesc);
        Change change = new Change(new Change(Flag.DESC_REMOVED, (IHasPosition[])new IDesc[]{oldDesc}), new Change(Flag.DESC_ADDED, (IHasPosition[])new IDesc[]{newDesc}));
        CharChange undo = new CharChange(this.replaceOffset, this.insertText.length(), oldText);
        StoryChangeEvent event = new StoryChangeEvent(source, model, CharRep.getInstance(), change, (IModelChange)this, (IModelChange)undo);
        return event;
    }
}

